<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
//$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.








/* ------------- Router site -----------------*/
$routes->get('/', 'Home::index');
$routes->post('/', 'Home::index');
$routes->get('/recover-password', 'Home::recover_password');
$routes->post('/recover-password-sended', 'Home::recover_password_sended');
$routes->get('/reassign-password', 'Home::reassign_password');
$routes->get('/perfil', 'Perfil::index');
$routes->get('/options', 'Options::index');



$routes->get('/library', 'Biblioteca::index');
$routes->get('/biblioteca/documentos', 'Biblioteca::documentos');
$routes->get('/biblioteca/cotizaciones', 'Biblioteca::cotizaciones');
$routes->get('/biblioteca/manuales', 'Biblioteca::manuales');



$routes->get('/usuarios', 'Users::index');
$routes->get('/usuarios/edit/(:any)', 'Users::edit/$1');
$routes->get('/usuarios/create', 'Users::create');
$routes->post('/usuarios/insert', 'Users::insert');
$routes->post('/usuarios/update', 'Users::update');


$routes->get('/realstates', 'Realstates::index');
$routes->get('/realstates/edit/(:any)', 'Realstates::edit/$1');
$routes->get('/realstates/create', 'Realstates::create');
$routes->post('/realstates/insert', 'Realstates::insert');
$routes->post('/realstates/update', 'Realstates::update');


$routes->get('/clientes', 'Clientes::index');
$routes->get('/clientes/edit/(:any)', 'Clientes::edit/$1');
$routes->get('/clientes/create', 'Clientes::create');
$routes->post('/clientes/insert', 'Clientes::insert');
$routes->post('/clientes/update', 'Clientes::update');





$routes->get('/expedientes', 'Expedientes::index');
$routes->get('/expedientes/details/(:any)', 'Expedientes::details/$1');
$routes->get('/expedientes/messages/(:any)', 'Expedientes::messages/$1');
$routes->get('/expedientes/library/(:any)', 'Expedientes::library/$1');

$routes->get('/expedientes/documentos/(:segment)', 'Expedientes::documentos/$1');
$routes->get('/expedientes/documentos/crear/(:segment)', 'Expedientes::documentos_crear/$1');
$routes->get('/expedientes/documentos/editar/(:segment)', 'Expedientes::documentos_editar/$1');
$routes->get('/expedientes/documentos/update/(:segment)', 'Expedientes::documentos_update/$1');

$routes->get('/expedientes/cotizaciones/(:segment)', 'Expedientes::cotizaciones/$1');
$routes->get('/expedientes/cotizaciones/crear/(:segment)', 'Expedientes::cotizaciones_crear/$1');
$routes->get('/expedientes/cotizaciones/editar/(:segment)', 'Expedientes::cotizaciones_editar/$1');
$routes->get('/expedientes/cotizaciones/update/(:segment)', 'Expedientes::cotizaciones_update/$1');

$routes->get('/expedientes/manuales/(:segment)', 'Expedientes::manuales/$1');
$routes->get('/expedientes/manuales/crear/(:segment)', 'Expedientes::manuales_crear/$1');
$routes->get('/expedientes/manuales/editar/(:segment)', 'Expedientes::manuales_editar/$1');
$routes->get('/expedientes/manuales/update/(:segment)', 'Expedientes::manuales_update/$1');

$routes->get('/expedientes/projects/(:segment)', 'Expedientes::projects/$1');
$routes->get('/expedientes/projects/crear/(:segment)', 'Expedientes::projects_crear/$1');
$routes->get('/expedientes/projects/editar/(:segment)', 'Expedientes::projects_editar/$1');
$routes->get('/expedientes/projects/update/(:segment)', 'Expedientes::projects_update/$1');












$routes->post('/api/save_new_password', 'Api::save_new_password');
$routes->post('/api/upload_image_user', 'Api::upload_image_user');
$routes->get('/api/upload_image_user', 'Api::upload_image_user');
$routes->post('/api/upload_new_image_user', 'Api::upload_new_image_user');
$routes->post('/api/upload_new_image_logo', 'Api::upload_new_image_logo');
$routes->post('/api/upload_new_image_cliente', 'Api::upload_new_image_cliente');
$routes->post('/api/upload_file', 'Api::upload_file');
$routes->post('/api/get_uploads', 'Api::get_uploads');
$routes->post('/api/get_upload_details', 'Api::get_upload_details');
$routes->post('/api/get_real_states', 'Api::get_real_states');
$routes->post('/api/get_clientes', 'Api::get_clientes');

$routes->post('/api/get_expedientes', 'Api::get_expedientes');
$routes->post('/api/upload_file_expediente', 'Api::upload_file_expediente');
$routes->post('/api/save_file_expediente', 'Api::save_file_expediente');
$routes->post('/api/update_upload_file_expediente', 'Api::update_upload_file_expediente');
$routes->post('/api/update_file_expediente', 'Api::update_file_expediente');

$routes->post('/api/get_mesagges_client', 'Api::get_mesagges_client');
$routes->post('/api/post_mesagges_client', 'Api::post_mesagges_client');


$routes->post('/api/delete_doc_record', 'Api::delete_doc_record');
$routes->post('/api/delete_library_record', 'Api::delete_library_record');
$routes->post('/api/create_new_project', 'Api::create_new_project');
$routes->post('/api/update_project', 'Api::update_project');
$routes->post('/api/update_settings', 'Api::update_settings');



$routes->post('/api/get_mesagges_document', 'Api::get_mesagges_document');
$routes->post('/api/post_mesagges_document', 'Api::post_mesagges_document');










$routes->get('/logout', 'Home::logout');




/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
