<?php

namespace App\Controllers;
use Config\Services;
//$session = \Config\Services::session();
use App\Models\UserModel;
use App\Models\RealstateModel;
use App\Models\DocumentosModel;
use App\Models\BibliotecaModel;
use App\Models\ExpedientesModel;
use App\Models\TasksModel;
use App\Models\MessagesModel;
use App\Models\ClientesModel;
use App\Models\OptionsModel;

$session = \Config\Services::session();
$session->start();

require_once dirname( __FILE__, 3 ) . '/vendor/autoload.php'; 
use Google\Cloud\Storage\StorageClient;



class Api extends BaseController
{
   
    public function index()
    {
        // test
    }


    
    function save_new_password(){
        $token=$_POST["token"];
        $new_password=$_POST["new_password"];
        
        $userModel = new UserModel();
        $usuario = $userModel->where('token_recover', $token)->first();
        //print_r($usuario); 

        if($usuario){
            $new_password=password_hash($new_password, PASSWORD_DEFAULT);
            $record = [
                'token_recover'    => NULL,
                'password'    => $new_password,
            ];    
            $userModel->update($usuario["id"], $record);
            echo json_encode(true);
        }else{
            echo json_encode(false);
        }


    }





    









    
    function upload_image_user(){
        
        $userModel = new UserModel();
        $folio=$_POST["folio"];
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png", "jpg", "jpeg", "gif");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$folio."_".$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/fotos_users/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'fotos_users/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);
            $userModel->where('folio', $folio)->set(['url_image' => $file_name])->update();
        }
        echo json_encode('https://storage.googleapis.com/'.getenv('bucket_name').'/fotos_users/'.$file_name);
    }




    
    


    function upload_new_image_logo(){
        
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png", "jpg", "jpeg", "gif");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/logos/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'logos/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);

        }
        echo json_encode($file_name);
    }



    
    function upload_new_image_user(){
        
        $userModel = new UserModel();
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png", "jpg", "jpeg", "gif");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/fotos_users/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'fotos_users/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);
        }
        echo json_encode($file_name);
    }












    
    function upload_new_image_cliente(){
        
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png", "jpg", "jpeg", "gif");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/fotos_clientes/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'fotos_clientes/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);
        }
        echo json_encode($file_name);
    }









    
    function upload_file(){
        
        
        $bibliotecaModel = new BibliotecaModel();
        $alt_name=$_POST['alt_name'];
        $type=$_POST['type'];
        $cliente=$_POST['cliente'];
        $extension=$_POST['extension'];
        $created_by=$_POST['created_by'];
        
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png","jpg","jpeg","gif","pdf","doc","docx","xls","csv","ppt");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$cliente."-".$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/biblioteca/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'biblioteca/'.$type.'/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);
            $folio=time();
            $data = [
                'alt_name'       => $alt_name,
                'uploaded_by'       => $created_by,
                'folio'       => $folio,
                'extension'        => $extension,
                'type' => $type,
                'cliente' => $cliente,
                'url_image' => getenv('bucket_url_biblioteca').'/'.$type.'/'.$file_name,
                'creation_date' => date('Y-m-d G:i:s'),
                'last_update' => date('Y-m-d G:i:s'),
            ];
            
            $bibliotecaModel->insert($data);
            
        }
        $response=array(
            "data" => getenv('bucket_url_biblioteca').'/'.$type.'/'.$file_name,
            "extension" => $extension,
            "folio" => $folio
        );

        echo json_encode($response);
    }





    function get_uploads(){
        
        $bibliotecaModel = new BibliotecaModel();
        $limit=$_POST['limit'];
        $offset=$_POST['offset'];
        $type=$_POST['type'];
        //$agencia=$_POST['agencia'];
        $cliente=$_POST['cliente'];

        
        $this->db = db_connect();

        /*if($agencia==0){
            $query = $this->db->query('SELECT COUNT(id) AS contador FROM biblioteca WHERE type="'.$type.'" ');
            $files = $bibliotecaModel->where('type', $type)->where('erased_flag', 0)->orderBy('creation_date', 'desc')->findAll($limit, $offset);
        }else{

            $query = $this->db->query('SELECT COUNT(id) AS contador FROM biblioteca WHERE agencia='.$agencia.' AND type="'.$type.'" ');
            $files = $bibliotecaModel->where('cliente', $cliente)->where('type', $type)->where('erased_flag', 0)->where('agencia', $agencia)->orderBy('creation_date', 'desc')->findAll($limit, $offset);
        }*/
        
        $query = $this->db->query('SELECT COUNT(id) AS contador FROM biblioteca WHERE cliente='.$cliente.' AND erased_flag=0 AND type="'.$type.'" ');
        $files = $bibliotecaModel->where('cliente', $cliente)->where('type', $type)->where('erased_flag', 0)->orderBy('creation_date', 'desc')->findAll($limit, $offset);
    
        $results = $query->getResult();
        $results=json_decode(json_encode($results), true);
        $total_records=$results[0]["contador"];
        
        if($results){
            $response=array(
                "data" => $files,
                "total" => $total_records
            );
        }else{
            $response=array(
                "data" => "Error",
                "total" => 0
            );
        } 
        echo json_encode($response);
    }






    function get_upload_details(){
        $bibliotecaModel = new BibliotecaModel();
        $folio=$_POST['folio'];
        $files = $bibliotecaModel->where('folio', $folio)->first();
        if($files){
            $response=array(
                "data" => $files
            );
        }else{
            $response=array(
                "data" => "Error"
            );
        }
        echo json_encode($response);
    }


    
    function get_real_states(){
        $realstateModel = new RealstateModel();
        $realstates = $realstateModel->where('erased_flag', 0)->findAll();
    
        if($realstates){
            $response=array(
                "data" => $realstates
            );
        }else{
            $response=array(
                "data" => "Error"
            );
        }
        echo json_encode($response);
    }

    
    function get_clientes(){
        $agencia=$_POST['agencia'];
        $ClientesModel = new ClientesModel();

        if($agencia==0){
            $users = $ClientesModel->where('erased_flag', 0)->findAll();
        }else{
            $users = $ClientesModel->where('erased_flag', 0)->where('agencia', $agencia)->findAll();
        }
    
        if($users){
            $response=array(
                "data" => $users
            );
        }else{
            $response=array(
                "data" => "Error"
            );
        }
        echo json_encode($response);
    }
    

    
    
    function get_expedientes(){
        $cliente=$_POST['cliente'];
        $ExpedientesModel = new ExpedientesModel();

        $expedientes = $ExpedientesModel->where('erased_flag', 0)->where('folio', $cliente)->findAll();
      
        if($expedientes){
            $response=array(
                "data" => $expedientes
            );
        }else{
            $response=array(
                "data" => "Empty"
            );
        }
        echo json_encode($response);
    }





    
    function save_file_expediente(){
        $DocumentosModel = new DocumentosModel();
        $name=$_POST['name'];
        $description=$_POST['description'];
        $type=$_POST['type'];
        $created_by=$_POST['created_by'];
        $cliente=$_POST['cliente'];
        $url=$_POST['url'];

        $folio=time();
        $data = [
            'folio'       => $folio,
            'name'        => $name,
            'description'        => $description,
            'type' => $type,
            'created_by' => $created_by,
            'cliente' => $cliente,
            'url' => $url,
            'creation_date' => date('Y-m-d G:i:s'),
            'last_update' => date('Y-m-d G:i:s'),
        ];
        
        $DocumentosModel->insert($data);
         
        $response=array(
            "data" => "Ok"
        );
        
        echo json_encode($response);


    }

    
    
    function update_file_expediente(){
        $DocumentosModel = new DocumentosModel();
        $folio=$_POST['folio'];
        $name=$_POST['name'];
        $description=$_POST['description'];
        $type=$_POST['type'];
        $created_by=$_POST['created_by'];
        $cliente=$_POST['cliente'];
        $url=$_POST['url'];

        $data = [
            'name'        => $name,
            'description'        => $description,
            'type' => $type,
            'created_by' => $created_by,
            'cliente' => $cliente,
            'url' => $url,
            'last_update' => date('Y-m-d G:i:s'),
        ];
        
        $DocumentosModel->where("folio", $folio)->set($data)->update();
         
        $response=array(
            "data" => "Ok"
        );
        
        echo json_encode($response);


    }

    
    
    function upload_file_expediente(){
        
        
        $DocumentosModel = new DocumentosModel();
        $type=$_POST['type'];
        $name=$_POST['name'];
        $description=$_POST['description'];
        $created_by=$_POST['created_by'];
        $cliente=$_POST['cliente'];
        
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png","jpg","jpeg","gif","pdf","doc","docx","xls","csv","ppt","pptx","xlsx","doc");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$cliente."-".$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/expedientes/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'expedientes/'.$type.'/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);

            $folio=time();
            $data = [
                'folio'       => $folio,
                'name'        => $name,
                'description'        => $description,
                'type' => $type,
                'created_by' => $created_by,
                'cliente' => $cliente,
                'url' => getenv('bucket_url_expediente').'/'.$type.'/'.$file_name,
                'creation_date' => date('Y-m-d G:i:s'),
                'last_update' => date('Y-m-d G:i:s'),
            ];
            
            $DocumentosModel->insert($data);
            
        }
        $response=array(
            "data" => getenv('bucket_url_expediente').'/'.$type.'/'.$file_name,
            "extension" => $extension,
            "folio" => $folio
        );

        echo json_encode($response);
    }







    function update_upload_file_expediente(){
        
        
        $DocumentosModel = new DocumentosModel();
        $folio=$_POST['folio'];
        $type=$_POST['type'];
        $name=$_POST['name'];
        $description=$_POST['description'];
        $created_by=$_POST['created_by'];
        $cliente=$_POST['cliente'];
        
        $filename="";
        $file_name="";
        if (isset($_FILES['assets'])) {                
            $errors = array();
            $total = count($_FILES['assets']['name']);
            //Verificar extension válida
            $expensions = array("png","jpg","jpeg","gif","pdf","doc","docx","xls","csv","ppt","pptx","xlsx","doc");
            for ($i = 0; $i < $total; $i++) {
                $filename = explode('.', $_FILES['assets']['name'][$i]);
                $file_ext = strtolower(end($filename));

                if (in_array($file_ext, $expensions) === false) {
                    $errors[] = "extension not allowed.";
                }
            }
            //Verificar tamaño
            for ($i = 0; $i < $total; $i++) {
                $limitSize = 104857600;
                if ($_FILES["assets"]["size"][$i] > $limitSize) {
                    $errors[] = "solo archivos menores a ".number_format($limitSize / 1048576, 0)."MB allowed.";
                }
            }
            if (empty($errors) == false) {
                echo json_encode($errors);
                die();
            }
        }
        if (isset($_FILES['assets'])) {
            $total = count($_FILES['assets']['name']);
            for ($i = 0; $i < $total; $i++) {
                $array = explode('.', $_FILES['assets']['name'][$i]);
                $extension = end($array);
                $file_name = date('YmdGisGis');
                $file_size = $_FILES['assets']['size'][$i];
                $file_tmp = $_FILES['assets']['tmp_name'][$i];
                $file_type = $_FILES['assets']['type'][$i];
                $timestamp=date('Y-m-d_G:i:s');
                $file_name=$cliente."-".$file_name.".".$extension;
                //Verificar si el archivo no existe en la bd
                $route = "writable/uploads/expedientes/";
                move_uploaded_file($file_tmp, $route . $file_name);                
            }
        }

        
        $storage = new StorageClient();
        $keyarray=json_decode(file_get_contents(dirname( __FILE__, 3) .'/airmedia-d82bc879bea8.json'), true);
        $storage = new StorageClient([
            'keyFile' => $keyarray
        ]);
        $storage = new StorageClient([
            'projectId' => 'airmedia'
        ]);
        $bucket = $storage->bucket(getenv('bucket_name'));
        if (!$file = fopen($route.$file_name, 'r')) {
            throw new \InvalidArgumentException('Unable to open file for reading');
        }else{
            $object = $bucket->upload($file, [
                'name' => 'expedientes/'.$type.'/'.$file_name, 'predefinedAcl' => 'publicRead'
            ]);
            unlink($route.$file_name);

            $data = [
                'name'        => $name,
                'description'        => $description,
                'type' => $type,
                'cliente' => $cliente,
                'url' => getenv('bucket_url_expediente').'/'.$type.'/'.$file_name,
                'last_update' => date('Y-m-d G:i:s'),
            ];
            
            $DocumentosModel->where("folio", $folio)->set($data)->update();
            
        }
        $response=array(
            "data" => getenv('bucket_url_expediente').'/'.$type.'/'.$file_name,
            "extension" => $extension,
            "folio" => $folio
        );

        echo json_encode($response);
    }












    
    
    function get_mesagges_client(){
        $client_id=$_POST["client_id"];
        
        $this->db = db_connect();
        
        $builder = $this->db->table("messages_client");
        $builder->where("client_id", $client_id);
        $builder->where('erased_flag', 0);
        $builder->orderBy("creation_date", "asc");
        $builder->select();
        $query = $builder->get();
        $messages=$query->getResult();

        if($messages){
            
            $response=array(
                'message' => "success",
                'data' => $messages,
                'code' => 200
            ); 
        }else{
            $response=array(
                'message' => "error",
                'data' => "",
                'code' => 404
            ); 
        }

        echo json_encode($response);

    }



    
    
    
    function get_mesagges_document(){
        $client_id=$_POST["client_id"];
        $documentofolio=$_POST["documentofolio"];
        
        $this->db = db_connect();
        
        $builder = $this->db->table("messages_document");
        $builder->where("client_id", $client_id);
        $builder->where("documentofolio", $documentofolio);
        $builder->where('erased_flag', 0);
        $builder->orderBy("creation_date", "asc");
        $builder->select();
        $query = $builder->get();
        $messages=$query->getResult();

        if($messages){
            
            $response=array(
                'message' => "success",
                'data' => $messages,
                'code' => 200
            ); 
        }else{
            $response=array(
                'message' => "error",
                'data' => "",
                'code' => 404
            ); 
        }

        echo json_encode($response);

    }
 


    function post_mesagges_client(){
        date_default_timezone_set('America/Mexico_City');

        $client_id=$_POST["client_id"];
        $origin=$_POST["origin"];
        $agency=$_POST["agency"];
        $message=$_POST["message"];
        
        $this->db = db_connect();
        $builder = $this->db->table("messages_client");
        
        $data = array(
            'client_id' => $client_id,
            'origin' => $origin,
            'agency' => $agency,
            'message' => $message,
            'creation_date' => date("Y-m-d H:i:s"),
        );
        
        $builder->insert($data);

        $response=array(
            'message' => "success",
            'code' => 200
        ); 
        

        echo json_encode($response);

    }



    function post_mesagges_document(){
        date_default_timezone_set('America/Mexico_City');

        $client_id=$_POST["client_id"];
        $origin=$_POST["origin"];
        $agency=$_POST["agency"];
        $message=$_POST["message"];
        $documentofolio=$_POST["documentofolio"];
        
        $this->db = db_connect();
        $builder = $this->db->table("messages_document");
        
        $data = array(
            'client_id' => $client_id,
            'origin' => $origin,
            'agency' => $agency,
            'message' => $message,
            'documentofolio' => $documentofolio,
            'creation_date' => date("Y-m-d H:i:s"),
        );
        
        $builder->insert($data);

        $response=array(
            'message' => "success",
            'code' => 200
        ); 
        

        echo json_encode($response);

    }

    

    function delete_doc_record(){
        date_default_timezone_set('America/Mexico_City');

        $folio=$_POST["folio"];
        $id_user=$_POST["id_user"];

        $DocumentosModel = new DocumentosModel();
        $data = [
            'erased_flag' => 1,
            'erased_by' => $id_user,
            'erased_time' => date('Y-m-d G:i:s'),
        ];
        $DocumentosModel->where('folio', $folio)->set($data)->update();
        $response=array(
            'message' => "success",
            'code' => 200
        ); 
        echo json_encode($response);

    }

    

    function delete_library_record(){
        date_default_timezone_set('America/Mexico_City');

        $folio=$_POST["folio"];
        $id_user=$_POST["id_user"];

        $bibliotecaModel = new BibliotecaModel();
        $data = [
            'erased_flag' => 1,
            'erased_by' => $id_user,
            'erased_time' => date('Y-m-d G:i:s'),
        ];
        $bibliotecaModel->where('folio', $folio)->set($data)->update();
        $response=array(
            'message' => "success",
            'code' => 200
        ); 
        echo json_encode($response);

    }



    function create_new_project(){

        date_default_timezone_set('America/Mexico_City');
        $this->db = db_connect();
        
        $created_by=$_POST["created_by"];
        $cliente_id=$_POST["cliente_id"];
        $name_project=$_POST["name_project"];
        $etapas=$_POST["etapas"];
        
        $TasksModel = new TasksModel();
        $ExpedientesModel = new ExpedientesModel();

        $folio_project=time();
        $data = [
            'name'       => $name_project,
            'folio'       => $folio_project,
            'cliente_id' => $cliente_id,
            'created_by' => $created_by,
            'creation_date' => date('Y-m-d G:i:s'),
            'last_update' => date('Y-m-d G:i:s'),
        ];
        
        $ExpedientesModel->insert($data);

        $count=0;
        foreach ($etapas as $key => $value) {
            $folio=time();
            $data = [
                'folio'       => $folio.$count,
                'project_folio'       => $folio_project,
                'name'       => $value["task_name_project"],
                'description'       => $value["task_description_project"],
                'comments'       => $value["task_commments_project"],
                'status'       => $value["task_status_project"],
                'responsibles'       => $value["task_responsable_project"],
                'start_date'       => $value["task_start_project"],
                'end_date'       => $value["task_end_project"],
                'requirements'       => $value["task_requerimientos_project"],
                'percent'       => $value["task_percentage_project"],
                'creation_date' => date('Y-m-d G:i:s'),
                'last_update' => date('Y-m-d G:i:s'),
            ];
            
            $TasksModel->insert($data);
            $count++;
        }
        

    
        $response=array(
            'data' => $folio_project,
            'message' => "success",
            'code' => 200
        ); 
        echo json_encode($response);


    
    }






    function update_project(){

        date_default_timezone_set('America/Mexico_City');
        $this->db = db_connect();
        
        $folio_project=$_POST["folio"];
        $created_by=$_POST["created_by"];
        $cliente_id=$_POST["cliente_id"];
        $name_project=$_POST["name_project"];
        $etapas=$_POST["etapas"];
        
        $TasksModel = new TasksModel();
        $ExpedientesModel = new ExpedientesModel();

        $data = [
            'name'       => $name_project,
            'cliente_id' => $cliente_id,
            'created_by' => $created_by,
            'creation_date' => date('Y-m-d G:i:s'),
            'last_update' => date('Y-m-d G:i:s'),
        ];
        

        $ExpedientesModel->where('folio', $folio_project)->set($data)->update();

        $count=0;
        foreach ($etapas as $key => $value) {

            $exist_task=$TasksModel->where('folio', $value["task_folio_project"])->first();
            if($exist_task){
                 $data = [
                    'project_folio'       => $folio_project,
                    'name'       => $value["task_name_project"],
                    'description'       => $value["task_description_project"],
                    'comments'       => $value["task_commments_project"],
                    'status'       => $value["task_status_project"],
                    'responsibles'       => $value["task_responsable_project"],
                    'start_date'       => $value["task_start_project"],
                    'end_date'       => $value["task_end_project"],
                    'requirements'       => $value["task_requerimientos_project"],
                    'percent'       => $value["task_percentage_project"],
                    'creation_date' => date('Y-m-d G:i:s'),
                    'last_update' => date('Y-m-d G:i:s'),
                ];
                
                
                $TasksModel->where('folio', $value["task_folio_project"])->set($data)->update();
            }else{
                $folio=time();
                $data = [
                    'folio'       => $folio.$count,
                    'project_folio'       => $folio_project,
                    'name'       => $value["task_name_project"],
                    'description'       => $value["task_description_project"],
                    'comments'       => $value["task_commments_project"],
                    'status'       => $value["task_status_project"],
                    'responsibles'       => $value["task_responsable_project"],
                    'start_date'       => $value["task_start_project"],
                    'end_date'       => $value["task_end_project"],
                    'requirements'       => $value["task_requerimientos_project"],
                    'percent'       => $value["task_percentage_project"],
                    'creation_date' => date('Y-m-d G:i:s'),
                    'last_update' => date('Y-m-d G:i:s'),
                ];
                
                $TasksModel->insert($data);
            }
            


            $count++;
        }
        

    
        $response=array(
            'data' => $folio_project,
            'message' => "success",
            'code' => 200
        ); 
        echo json_encode($response);


    
    }






    function update_settings(){
        $auth_logo=$_POST["auth_logo"];
        $logo_icon=$_POST["logo_icon"];
        $brand_color=$_POST["brand_color"];
        $brand_name=$_POST["brand_name"];
        
        
        $OptionsModel = new OptionsModel();
        $OptionsModel->where('field', "auth_logo")->set(['value' => $auth_logo])->update();
        $OptionsModel->where('field', "logo_icon")->set(['value' => $logo_icon])->update();
        $OptionsModel->where('field', "brand_color")->set(['value' => $brand_color])->update();
        $OptionsModel->where('field', "brand_name")->set(['value' => $brand_name])->update();
        
        
        echo json_encode("done");

    }























































}
