<?php

namespace App\Controllers;
use Config\Services;
//$session = \Config\Services::session();
use App\Models\UserModel;
use App\Models\RealstateModel;
use App\Models\ClientesModel;
$session = \Config\Services::session();
$session->start();



class Clientes extends BaseController
{

    public function index()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            $RealstateModel = new RealstateModel();
            
            $ClientesModel = new ClientesModel();
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            
            
            //print_r($users);
            
            if($_SESSION["user_type"]==0){
                $realstates = $RealstateModel->findAll();
                $results = $ClientesModel->findAll();
                $data = [
                    'current_user' => $current_user,
                    'realstates' => $realstates,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'current' => 'Clientes',
                    'results' => $results,
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("clientes")
                .view("scripts");
            }else{
                
                if($_SESSION["user_type"]==1 || $_SESSION["user_type"]==2){
                    $realstates = $RealstateModel->where('id', $_SESSION["agencia"])->findAll();
                    $results = $ClientesModel->where('agencia', $_SESSION["agencia"])->findAll();
                    $data = [
                        'current_user' => $current_user,
                        'realstates' => $realstates,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'current' => 'Clientes',
                        'results' => $results,
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("clientes")
                    .view("scripts");
                }else{
                    return redirect()->to(base_url());
                }
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }




    
    public function create()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            
            $RealstateModel = new RealstateModel();

            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
           
            
            if($_SESSION["user_type"]==0){
                $realstates = $RealstateModel->findAll();
                $data = [
                    'current_user' => $current_user,
                    'realstates' => $realstates,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'current' => 'Clientes',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("create-cliente")
                .view("scripts");
            }else{
                if($_SESSION["user_type"]==1){
                    $realstates = $RealstateModel->where('id', $_SESSION["agencia"])->findAll();
                    $data = [
                        'current_user' => $current_user,
                        'realstates' => $realstates,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'current' => 'Clientes',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("create-cliente")
                    .view("scripts");
                }else{
                    return redirect()->to(base_url());
                }

            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }








    
    public function insert()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            if($_SESSION["user_type"]==0){

                    $ClientesModel = new ClientesModel();
                    $data = [
                        'folio'       => time(),
                        'filename'        => $_POST["filename"],
                        'first_name'        => $_POST["first_name"],
                        'last_name'        => $_POST["last_name"],
                        'email' => $_POST["email"],
                        'phone' => $_POST["phone"],
                        'url_image' => $_POST["url_image"],
                        'agencia' => $_POST["agencia"],
                        'creation_date' => date('Y-m-d G:i:s'),
                        'last_update' => date('Y-m-d G:i:s'),
                    ];
                    
                    $ClientesModel->insert($data);
                    
                    return redirect()->to(base_url()."/clientes");
                    

            }else{
                 if($_SESSION["user_type"]==1){
                    $ClientesModel = new ClientesModel();
                    $data = [
                        'folio'       => time(),
                        'filename'        => $_POST["filename"],
                        'first_name'        => $_POST["first_name"],
                        'last_name'        => $_POST["last_name"],
                        'email' => $_POST["email"],
                        'phone' => $_POST["phone"],
                        'url_image' => $_POST["url_image"],
                        'agencia' => $_POST["agencia"],
                        'creation_date' => date('Y-m-d G:i:s'),
                        'last_update' => date('Y-m-d G:i:s'),
                    ];
                    
                    $ClientesModel->insert($data);
                    
                    return redirect()->to(base_url()."/clientes");
                }else{
                    return redirect()->to(base_url());
                }
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }















    
    public function edit($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            $RealstateModel = new RealstateModel();
            $realstates = $RealstateModel->findAll();


            $ClientesModel = new ClientesModel();
            $usuario = $ClientesModel->where('folio', $record_id)->first();
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $data = [
                'current_user' => $current_user,
                'realstates' => $realstates,
                'template_color' => 'theme-green',
                'status' => "error",
                'current' => 'Clientes',
                'results' => $usuario,
                'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
            ];
            
            
            if($_SESSION["user_type"]==0){
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("edit-cliente")
                .view("scripts");
            }else{
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("edit-cliente")
                .view("scripts");
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }






  






    public function update()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            if($_SESSION["user_type"]==0 || $_SESSION["user_type"]==1){

                    $ClientesModel = new ClientesModel();
                    $data = [
                        'filename'        => $_POST["filename"],
                        'first_name'        => $_POST["first_name"],
                        'last_name'        => $_POST["last_name"],
                        'email' => $_POST["email"],
                        'phone' => $_POST["phone"],
                        'url_image' => $_POST["url_image"],
                        'last_update' => date('Y-m-d G:i:s'),
                    ];
                    
                    $ClientesModel->update($_POST["id"], $data);

                    return redirect()->to(base_url()."/clientes");

            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }























    
    function custom_random_string_alpha($length) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[ord(random_bytes(1)) % $charactersLength];
        }
        return $randomString;
    }
    
    
    function send_email_mailjet($post_json) {
        $curl = curl_init();
            
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.mailjet.com/v3/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $post_json,
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'user: 18869dfe9e6e215645054e4de644f2fc:a654193ef1af770921b6946ad030a537',
            'Authorization: Basic OWY2ZjA0ZjZhZDZmZTRhNzJmYzIxYThjMWRmNDlkN2Q6NjljNjFiMTNiMmQwM2I2N2Q1ZDk2ZTAwN2IyNDRiZTQ='
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);


        return $response;
    }



}
