<?php

namespace App\Controllers;
use Config\Services;
//$session = \Config\Services::session();
use App\Models\RealstateModel;
use App\Models\UserModel;
use App\Models\ClientesModel;
use App\Models\ExpedientesModel;
use App\Models\DocumentosModel;
use App\Models\TasksModel;
$session = \Config\Services::session();
$session->start();


class Expedientes extends BaseController
{

    public function index()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }

            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $data = [
                'current_user' => $current_user,
                'template_color' => 'theme-green',
                'status' => "error",
                'current' => 'Expedientes',
                'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
            ];
            
            //print_r($users);
            
            if($_SESSION["user_type"]==0){
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("expedientes")
                .view("scripts");
            }else{
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("expedientes")
                .view("scripts");
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }



    public function details($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }

            
            
            
            //print_r($documentos);
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();

            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();

            $DocumentosModel = new DocumentosModel();
            $documentos = $DocumentosModel->where('erased_flag', 0)->where('cliente',  $record_id)->where('type', "documentos")->orderBy('creation_date', 'desc')->findAll(5);
            $cotizaciones = $DocumentosModel->where('erased_flag', 0)->where('cliente',  $record_id)->where('type', "cotizaciones")->orderBy('creation_date', 'desc')->findAll(5);
            $manuales = $DocumentosModel->where('erased_flag', 0)->where('cliente',  $record_id)->where('type', "manuales")->orderBy('creation_date', 'desc')->findAll(5);
            $usuarios_admin = $userModel->findAll();

            if($cliente){
                 $data = [
                    'usuarios_admin' => $usuarios_admin,
                    'cliente' => $cliente,
                    'documentos' => $documentos,
                    'cotizaciones' => $cotizaciones,
                    'manuales' => $manuales,
                    'current_user' => $current_user,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'aside' => "expediente",
                    'current' => 'Expedientes',
                    'expediente_menu' => 'details',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                    if($_SESSION["user_type"]==0){
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-details")
                        .view("scripts");
                    }else{
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-details")
                        .view("scripts");
                    }

            }else{
                return redirect()->to(base_url());
            }
           
            
            //print_r($users);
            
          

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }















    
    public function documentos($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documentos = $DocumentosModel->where('erased_flag', 0)->where('cliente',  $record_id)->where('type', "documentos")->orderBy('creation_date', 'desc')->findAll();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();
                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documentos,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'documentos',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentos")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentos")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());           
        }
    }

    
    public function documentos_crear($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();
                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'documentos',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentoscrear")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentoscrear")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());    
        }
    }

    
    public function documentos_editar($record_id='' )
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documento = $DocumentosModel->where('folio',  $record_id)->first();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();
                if($documento){
                    $ClientesModel = new ClientesModel();
                    $cliente = $ClientesModel->where('folio', $documento["cliente"])->first();
                    $documento["creador"]=$userModel->where('id', $documento["created_by"])->first();
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documento,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'documentos',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentosedit")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentosedit")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());      
        }
    }

    
    public function documentos_update($record_id='' )
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documento = $DocumentosModel->where('folio',  $record_id)->first();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();
                if($documento){
                    $ClientesModel = new ClientesModel();
                    $cliente = $ClientesModel->where('folio', $documento["cliente"])->first();
                    $documento["creador"]=$userModel->where('id', $documento["created_by"])->first();
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documento,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'documentos',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentosupdate")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-documentosupdate")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());      
        }
    }













    
    public function cotizaciones($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documentos = $DocumentosModel->where('erased_flag', 0)->where('cliente',  $record_id)->where('type', "cotizaciones")->orderBy('creation_date', 'desc')->findAll();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();
                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documentos,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'cotizaciones',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizaciones")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizaciones")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());           
        }
    }

    
    public function cotizaciones_crear($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();
                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'cotizaciones',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizacionescrear")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizacionescrear")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());    
        }
    }

    
    public function cotizaciones_editar($record_id='' )
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documento = $DocumentosModel->where('folio',  $record_id)->first();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();
                if($documento){
                    $ClientesModel = new ClientesModel();
                    $cliente = $ClientesModel->where('folio', $documento["cliente"])->first();
                    $documento["creador"]=$userModel->where('id', $documento["created_by"])->first();
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documento,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'cotizaciones',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizacionesedit")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizacionesedit")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());      
        }
    }


    
    public function cotizaciones_update($record_id='' )
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documento = $DocumentosModel->where('folio',  $record_id)->first();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();
                if($documento){
                    $ClientesModel = new ClientesModel();
                    $cliente = $ClientesModel->where('folio', $documento["cliente"])->first();
                    $documento["creador"]=$userModel->where('id', $documento["created_by"])->first();
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documento,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'cotizaciones',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizacionesupdate")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-cotizacionesupdate")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());      
        }
    }
















    
    public function manuales($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documentos = $DocumentosModel->where('erased_flag', 0)->where('cliente',  $record_id)->where('type', "manuales")->orderBy('creation_date', 'desc')->findAll();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();

                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documentos,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'manuales',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manuales")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manuales")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());           
        }
    }

    
    public function manuales_crear($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();
                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'manuales',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manualescrear")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manualescrear")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());    
        }
    }

    
    public function manuales_editar($record_id='' )
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documento = $DocumentosModel->where('folio',  $record_id)->first();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();
                if($documento){
                    $ClientesModel = new ClientesModel();
                    $cliente = $ClientesModel->where('folio', $documento["cliente"])->first();
                    $documento["creador"]=$userModel->where('id', $documento["created_by"])->first();
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documento,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'manuales',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manualesedit")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manualesedit")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());      
        }
    }


    public function manuales_update($record_id='' )
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $DocumentosModel = new DocumentosModel();
            $documento = $DocumentosModel->where('folio',  $record_id)->first();
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();
                if($documento){
                    $ClientesModel = new ClientesModel();
                    $cliente = $ClientesModel->where('folio', $documento["cliente"])->first();
                    $documento["creador"]=$userModel->where('id', $documento["created_by"])->first();
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'results' => $documento,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'manuales',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manualesupdate")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-manualesupdate")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());      
        }
    }



















    

    public function messages($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            //print_r($documentos);
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();

            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();

            $this->db = db_connect();
            
            /*$builder = $this->db->table("messages_client");
            $builder->where("client_id", $cliente["id"]);
            $builder->select();
            $query = $builder->get();
            $messages=$query->getResult();*/
            


            if($cliente){
                 $data = [
                    'usuarios_admin' => $usuarios_admin,
                    'cliente' => $cliente,
                    'current_user' => $current_user,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'aside' => "expediente",
                    'current' => 'Expedientes',
                    'expediente_menu' => 'messages',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                    if($_SESSION["user_type"]==0){
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-messages")
                        .view("scripts");
                    }else{
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-messages")
                        .view("scripts");
                    }
            }else{
                return redirect()->to(base_url());
            }
           
            
            //print_r($users);
            
          

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }












    
    public function projects($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            //print_r($documentos);
            $this->db = db_connect();
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();

            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();

            
            $ExpedientesModel = new ExpedientesModel();
            $projects = $ExpedientesModel->where('erased_flag', 0)->where('cliente_id', $record_id)->findAll();



            
            /*$builder = $this->db->table("messages_client");
            $builder->where("client_id", $cliente["id"]);
            $builder->select();
            $query = $builder->get();
            $messages=$query->getResult();*/
            


            if($cliente){
                 $data = [
                    'results' => $projects,
                    'usuarios_admin' => $usuarios_admin,
                    'cliente' => $cliente,
                    'current_user' => $current_user,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'aside' => "expediente",
                    'current' => 'Expedientes',
                    'expediente_menu' => 'projects',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                    if($_SESSION["user_type"]==0){
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-projects")
                        .view("scripts");
                    }else{
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-projects")
                        .view("scripts");
                    }
            }else{
                return redirect()->to(base_url());
            }
           
            
            //print_r($users);
            
          

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }

    
    public function projects_crear($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();
            $usuarios_admin = $userModel->findAll();
                if($cliente){
                    $data = [
                        'usuarios_admin' => $usuarios_admin,
                        'cliente' => $cliente,
                        'current_user' => $current_user,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'aside' => "expediente",
                        'current' => 'Expedientes',
                        'expediente_menu' => 'projects',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-projectscrear")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("expedientes-projectscrear")
                    .view("scripts");
                }
            }else{
                return redirect()->to(base_url());
            }
        }else{
            return redirect()->to(base_url());    
        }
    }










    
    public function projects_editar($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            //print_r($documentos);
            $this->db = db_connect();
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();

            $usuarios_admin = $userModel->findAll();

            
            $ExpedientesModel = new ExpedientesModel();
            $TasksModel = new TasksModel();
            $project = $ExpedientesModel->where('erased_flag', 0)->where('folio', $record_id)->findAll();
            $tasks = $TasksModel->where('erased_flag', 0)->where('project_folio', $record_id)->findAll();


            //print_r($project);

            if($project){
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $project[0]["cliente_id"])->first();

                 $data = [
                    'project' => $project,
                    'results' => $tasks,
                    'usuarios_admin' => $usuarios_admin,
                    'cliente' => $cliente,
                    'current_user' => $current_user,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'aside' => "expediente",
                    'current' => 'Expedientes',
                    'expediente_menu' => 'projects',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                    if($_SESSION["user_type"]==0){
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-projectsview")
                        .view("scripts");
                    }else{
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-projectsview")
                        .view("scripts");
                    }
            }else{
                return redirect()->to(base_url());
            }
           
            
            //print_r($users);
            
          

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }










    
    
    public function projects_update($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            //print_r($documentos);
            $this->db = db_connect();
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();

            $usuarios_admin = $userModel->findAll();

            
            $ExpedientesModel = new ExpedientesModel();
            $TasksModel = new TasksModel();
            $project = $ExpedientesModel->where('erased_flag', 0)->where('folio', $record_id)->findAll();
            $tasks = $TasksModel->where('erased_flag', 0)->where('project_folio', $record_id)->findAll();


            //print_r($project);

            if($project){
            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $project[0]["cliente_id"])->first();

                 $data = [
                    'project' => $project,
                    'results' => $tasks,
                    'usuarios_admin' => $usuarios_admin,
                    'cliente' => $cliente,
                    'current_user' => $current_user,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'aside' => "expediente",
                    'current' => 'Expedientes',
                    'expediente_menu' => 'projects',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                    if($_SESSION["user_type"]==0){
                        return view('head', $data)
                        .view("aside")
                        .view("header")
                        .view("expedientes-projectsupdate")
                        .view("scripts");
                    }else{
                        return redirect()->to(base_url());
                    }
            }else{
                return redirect()->to(base_url());
            }
           
            
            //print_r($users);
            
          

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }





    

    
    public function library($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            
            $realstateModel = new RealstateModel();
            $realstates = $realstateModel->findAll();
            

            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $usuarios_admin = $userModel->findAll();


            $ClientesModel = new ClientesModel();
            $cliente = $ClientesModel->where('folio', $record_id)->first();

            if($cliente){

                $data = [
                    'cliente' => $cliente,
                    'current_user' => $current_user,
                    'usuarios_admin' => $usuarios_admin,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'aside' => "expediente",
                    'current' => 'Expedientes',
                    'expediente_menu' => 'library',
                    'realstates' => $realstates,
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                
                //print_r($users);
                
                if($_SESSION["user_type"]==0){
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("documentos")
                    .view("scripts");
                }else{
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("documentos")
                    .view("scripts");
                }

            }else{
                return redirect()->to(base_url());
            }


        }else{
         
            return redirect()->to(base_url());
                    
        }
    }







































}
