<?php

namespace App\Controllers;
use Config\Services;
//$session = \Config\Services::session();
use App\Models\UserModel;
use App\Models\RealstateModel;
use App\Models\OptionsModel;
$session = \Config\Services::session();
$session->start();

class Home extends BaseController
{
   
    public function index()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            

            
            
            



            if($_SESSION["user_type"]==0){

                        $this->db = db_connect();

                        $builder = $this->db->table("clientes")->select("COUNT(id) AS cantidad")->where('erased_flag', 0);
                        $query = $builder->get();
                        $clientes_count=$query->getResult();
                        
                        $builder = $this->db->table("real_states")->select("COUNT(id) AS cantidad")->where('erased_flag', 0);
                        $query = $builder->get();
                        $real_states_count=$query->getResult();
                        
                        $builder = $this->db->table("messages_client")->select("COUNT(id) AS cantidad")->where('erased_flag', 0);
                        $query = $builder->get();
                        $messages_count=$query->getResult();

                        $builder = $this->db->table("documentos")->select("COUNT(id) AS cantidad")->where("type", "documentos")->where('erased_flag', 0);
                        $query = $builder->get();
                        $documentos_count=$query->getResult();
                        
                        $builder = $this->db->table("documentos")->select("COUNT(id) AS cantidad")->where("type", "manuales")->where('erased_flag', 0);
                        $query = $builder->get();
                        $manuales_count=$query->getResult();
                        
                        $builder = $this->db->table("real_states")->where("id", $_SESSION["agencia"])->select();
                        $query = $builder->get();
                        $current_agency=$query->getResult();
                        
                        $builder = $this->db->table("clientes")->select("*")->where('erased_flag', 0)->limit(3)->orderBy('id', 'DESC');
                        $query = $builder->get();
                        $last_clientes=$query->getResult();
                        
                        $builder = $this->db->table("real_states")->select("*")->where('erased_flag', 0)->limit(3)->orderBy('id', 'DESC');
                        $query = $builder->get();
                        $last_real_states=$query->getResult();
                        
                        $optionsModel = new OptionsModel();
                        $options = $optionsModel->findAll();

                        $userModel = new UserModel();
                        $current_user = $userModel->where('email', $_SESSION["email"])->first();
                        $data = [    
                            'options' => $options,
                            'last_clientes' => $last_clientes,
                            'last_real_states' => $last_real_states,
                            'current_agency' => $current_agency,
                            'messages_count' => $messages_count,
                            'documentos_count' => $documentos_count,
                            'manuales_count' => $manuales_count,
                            'real_states_count' => $real_states_count,
                            'clientes_count' => $clientes_count,
                            'current_user' => $current_user,
                            'template_color' => 'theme-green',
                            'status' => "error",
                            'current' => 'Dashboard',
                            'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                        ];



                return view('head', $data)
                .view("aside")
                .view("header")
                .view("dashboard")
                .view("scripts");

            }else{

                $this->db = db_connect();

                $builder = $this->db->table("clientes")->select("COUNT(id) AS cantidad")->where('erased_flag', 0)->where('agencia', $_SESSION["agencia"]);
                $query = $builder->get();
                $clientes_count=$query->getResult();
                
                $builder = $this->db->table("documentos")->select("COUNT(id) AS cantidad")->where("type", "documentos")->where('erased_flag', 0);
                $query = $builder->get();
                $documentos_count=$query->getResult();
                
                $builder = $this->db->table("documentos")->select("COUNT(id) AS cantidad")->where("type", "manuales")->where('erased_flag', 0);
                $query = $builder->get();
                $manuales_count=$query->getResult();
                
                $builder = $this->db->table("real_states")->where("id", $_SESSION["agencia"])->select();
                $query = $builder->get();
                $current_agency=$query->getResult();
                
                $builder = $this->db->table("clientes")->select("*")->where('erased_flag', 0)->limit(3)->orderBy('id', 'DESC')->where('agencia', $_SESSION["agencia"]);
                $query = $builder->get();
                $last_clientes=$query->getResult();
                

                $optionsModel = new OptionsModel();
                $options = $optionsModel->findAll();

                $userModel = new UserModel();
                $current_user = $userModel->where('email', $_SESSION["email"])->first();
                $data = [
                    'options' => $options,
                    'last_clientes' => $last_clientes,
                    'current_agency' => $current_agency,
                    'documentos_count' => $documentos_count,
                    'manuales_count' => $manuales_count,
                    'clientes_count' => $clientes_count,
                    'current_user' => $current_user,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'current' => 'Dashboard',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];

                return view('head', $data)
                .view("aside")
                .view("header")
                .view("dashboard")
                .view("scripts");
            }


        }else{
            $current_view="Login";
            if(isset($_POST["email"])){
                $email=$_POST["email"];
                $password=$_POST["password"];
                //print_r($_POST);
                
                $this->db = db_connect();
                $builder = $this->db->table("admin_users");
                $builder->where("erased_flag", 0);
                $builder->where("email", $email);
                $builder->select();
                $query = $builder->get();
                $result=$query->getResult();
    
                $usuario=json_decode(json_encode($result), true);


                if($usuario){
                    if(password_verify($password, $usuario[0]["password"])) {
                        if (isset($_POST["rememberme"]) && $_POST["rememberme"]=="on") {
                            $start= time(); // Taking now logged in time.
                            $expire= $start + (60 * 60 * 24 * 365 * 10);
                        } else {
                            $start= time(); // Taking now logged in time.
                            $expire= $start + (60 * 60 * 24);
                        }
                        
                        if($usuario[0]["agencia"]==0){
                                                        
                            $OptionsModel = new OptionsModel();
                            $options_query = $OptionsModel->findAll();
                            
                            $logo_custom=$options_query[0]["value"];
                            $icon_custom=$options_query[1]["value"];
                            $color_custom=$options_query[2]["value"];
                        }else{
                            $RealstateModel = new RealstateModel();
                            $realstates = $RealstateModel->where('id', $usuario[0]["agencia"])->first();
                            $color_custom=$realstates["color"];
                            $icon_custom=$realstates["url_image"];
                            $logo_custom=$realstates["url_image"];
                        }

                        $data=[
                            "id" => $usuario[0]["id"],
                            "folio" => $usuario[0]["folio"],
                            "first_name" => $usuario[0]["first_name"],
                            "last_name" => $usuario[0]["last_name"],
                            "fullname" => $usuario[0]["first_name"]." ".$usuario[0]["last_name"],
                            "email" => $usuario[0]["email"],
                            "phone" => $usuario[0]["phone"],
                            "url_image" => $usuario[0]["url_image"],
                            "job_title" => $usuario[0]["job_title"],
                            "user_type" => $usuario[0]["user_type"],
                            "agencia" => $usuario[0]["agencia"],
                            "color_custom" => $color_custom,
                            "logo_custom" => $logo_custom,
                            "icon_custom" => $icon_custom,
                            "start" => $start,
                            "expire" => $expire,
                        ];
                        session()->sess_expiration = $expire;
                        session()->set($data);
                        return redirect()->to(base_url());
                    }else{
                        
                        $OptionsModel = new OptionsModel();
                        $options_query = $OptionsModel->findAll();
                        
                        $logo_custom=$options_query[0]["value"];
                        $icon_custom=$options_query[1]["value"];
                        $color_custom=$options_query[2]["value"];
                        
                        $data = [
                            "color_custom" => $color_custom,
                            "logo_custom" => $logo_custom,
                            "icon_custom" => $icon_custom,
                            'template_color' => 'theme-green',
                            'status' => "error",
                            'current' => 'Login'
                        ];
                        return view('head-login', $data)
                            .view("login")
                            .view("scripts");
                    }
                }else{
                    
                    $OptionsModel = new OptionsModel();
                    $options_query = $OptionsModel->findAll();
                    
                    $logo_custom=$options_query[0]["value"];
                    $icon_custom=$options_query[1]["value"];
                    $color_custom=$options_query[2]["value"];

                    $data = [
                        "color_custom" => $color_custom,
                        "logo_custom" => $logo_custom,
                        "icon_custom" => $icon_custom,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'current' => 'Login'
                    ];
                    return view('head-login', $data)
                        .view("login")
                        .view("scripts");
                }
    
    
            }else{
                
                $OptionsModel = new OptionsModel();
                $options_query = $OptionsModel->findAll();
                                
                $logo_custom=$options_query[0]["value"];
                $icon_custom=$options_query[1]["value"];
                $color_custom=$options_query[2]["value"];

                $data = [
                    'template_color' => 'theme-green',
                    'status' => "none",
                    'current' => 'Login',
                    'logo_custom' => $logo_custom,
                    'icon_custom' => $icon_custom,
                    'color_custom' => $color_custom,
                ];
                return view('head-login', $data)
                    .view("login")
                    .view("scripts");
            }
                    
        }
    }



    function logout(){
        session()->destroy();
        return redirect()->to(base_url());
    }
    

    function recover_password(){
        if(isset($_SESSION["email"])){
            return redirect()->to(base_url());
        }else{

            $OptionsModel = new OptionsModel();
            $options_query = $OptionsModel->findAll();
            
            $logo_custom=$options_query[0]["value"];
            $icon_custom=$options_query[1]["value"];
            $color_custom=$options_query[2]["value"];
            
            $data = [
                'template_color' => 'theme-green',
                'status' => "none",
                'current' => 'Recuperación de contraseña',
                'logo_custom' => $logo_custom,
                'icon_custom' => $icon_custom,
                'color_custom' => $color_custom,
            ];

            return view('head-login', $data)
            .view("recover_password")
            .view("scripts");
        }

    }

    function recover_password_sended(){
        if(isset($_SESSION["email"])){
            return redirect()->to(base_url());
        }else{
            $userModel = new UserModel();
            $usuario = $userModel->where('email', $_POST["email"])->first();

            if($usuario){
                
                $token_recover=$this->custom_random_string_alpha(10);
            
                $record = [
                    'token_recover'    => $token_recover,
                ];
                $userModel->update($usuario["id"], $record);

                $post_json='{
                    "FromEmail":"contacto-dcm@develops.mx",
                    "FromName":"Recuperación de contraseña",
                    "Subject": "DCM",
                    "Text-part":"",
                    "Html-part": "<h1>Hola '.$usuario["first_name"].'</h1><p>Se ha generado un link de recuperación de contraseña para tu cuenta, da click en el enlace siguiente:</p><p><a href=\"'.base_url().'/reassign-password?token='.$token_recover.'\">'.base_url().'/reasign-password?token='.$token_recover.'</a></p> <p>Si no fuiste tú ignora el correo.</p>",
                    "Recipients": [{"Email":"'.$usuario["email"].'"}]
                }';
                
                /* -------------------------------------- Enviar correo de recuperación --------------------------------- */
                
                $response_email=$this->send_email_mailjet($post_json);

                //echo $response_email;
            }

            $OptionsModel = new OptionsModel();
            $options_query = $OptionsModel->findAll();
                            
            $logo_custom=$options_query[0]["value"];
            $icon_custom=$options_query[1]["value"];
            $color_custom=$options_query[2]["value"];

            $data = [
                'template_color' => 'theme-green',
                'status' => "done",
                'current' => 'Recuperación de contraseña',
                'logo_custom' => $logo_custom,
                'icon_custom' => $icon_custom,
                'color_custom' => $color_custom,
            ];

            return view('head-login', $data)
            .view("recover_password")
            .view("scripts");
        }

    }



    
    function reassign_password(){
        if(isset($_SESSION["email"])){
            return redirect()->to(base_url());
        }else{

            $userModel = new UserModel();
            $usuario = $userModel->where('token_recover', $_GET["token"])->first();

            
            $OptionsModel = new OptionsModel();
            $options_query = $OptionsModel->findAll();
                            
            $logo_custom=$options_query[0]["value"];
            $icon_custom=$options_query[1]["value"];
            $color_custom=$options_query[2]["value"];

            $data = [
                'template_color' => 'theme-green',
                'status' => "none",
                'current' => 'Reasignar de contraseña',
                'logo_custom' => $logo_custom,
                'icon_custom' => $icon_custom,
                'color_custom' => $color_custom,
            ];

            if($usuario){
                return view('head-login', $data)
                    .view("new_password")
                    .view("scripts");
            }else{
                return view('head-login', $data)
                    .view("new_password_expired")
                    .view("scripts");
            }

        }

    }

  







    function custom_random_string_alpha($length) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[ord(random_bytes(1)) % $charactersLength];
        }
        return $randomString;
    }

    
    
    function send_email_mailjet($post_json) {
        $curl = curl_init();
            
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.mailjet.com/v3/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $post_json,
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'user: 18869dfe9e6e215645054e4de644f2fc:a654193ef1af770921b6946ad030a537',
            'Authorization: Basic OWY2ZjA0ZjZhZDZmZTRhNzJmYzIxYThjMWRmNDlkN2Q6NjljNjFiMTNiMmQwM2I2N2Q1ZDk2ZTAwN2IyNDRiZTQ='
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);


        return $response;
    }

    

    /*function send_email_mailjet_2($mail_FromEmail, $mail_FromName, $mail_Subject, $mail_Text, $mail_Html, $mail_Recipients) {
        $curl = curl_init();
            
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.mailjet.com/v3/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
                "FromEmail":'.$mail_FromEmail.',
                "FromName":'.$mail_FromName.',
                "Subject":'.$mail_Subject.',
                "Text-part":'.$mail_Text.',
                "Html-part": '.$mail_Html.',
                "Recipients": '.$mail_Recipients.'
            }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'user: 18869dfe9e6e215645054e4de644f2fc:a654193ef1af770921b6946ad030a537',
            'Authorization: Basic OWY2ZjA0ZjZhZDZmZTRhNzJmYzIxYThjMWRmNDlkN2Q6NjljNjFiMTNiMmQwM2I2N2Q1ZDk2ZTAwN2IyNDRiZTQ='
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);


        echo $response;
    }*/

    
    

















}
