<?php

namespace App\Controllers;
use Config\Services;
//$session = \Config\Services::session();
use App\Models\RealstateModel;
use App\Models\UserModel;
$session = \Config\Services::session();
$session->start();


class Realstates extends BaseController
{

    public function index()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }

            
            $realstateModel = new RealstateModel();
            $realstates = $realstateModel->findAll();
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $data = [
                'current_user' => $current_user,
                'template_color' => 'theme-green',
                'status' => "error",
                'current' => 'Realstates',
                'results' => $realstates,
                'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
            ];
            
            //print_r($users);
            
            if($_SESSION["user_type"]==0){
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("realstates")
                .view("scripts");
            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }




    
    
    public function create()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $data = [
                'current_user' => $current_user,
                'template_color' => 'theme-green',
                'status' => "error",
                'current' => 'Realstates',
                'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
            ];
            
            
            if($_SESSION["user_type"]==0){
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("create-realstate")
                .view("scripts");
            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }

    
    
    public function insert()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            
            if($_SESSION["user_type"]==0){

                

                $RealstateModel = new RealstateModel();
                $data = [
                    'folio'       => time(),
                    'nombre'        => $_POST["nombre"],
                    'url_image'        => $_POST["url_image"],
                    'color' => $_POST["color"],
                    'razon_social' => $_POST["razon_social"],
                    'rfc' => $_POST["rfc"],
                    'address_street' => $_POST["address_street"],
                    'address_suburb' => $_POST["address_suburb"],
                    'address_cp' => $_POST["address_cp"],
                    'contact_name' => $_POST["contact_name"],
                    'contact_email' => $_POST["contact_email"],
                    'contact_phone' => $_POST["contact_phone"],
                    'last_update' => date('Y-m-d G:i:s'),
                    'creation_date' => date('Y-m-d G:i:s'),
                ];
                
                $RealstateModel->insert($data);
                
                return redirect()->to(base_url()."/realstates");

            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }

    

    public function edit($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            $RealstateModel = new RealstateModel();
            $realstate = $RealstateModel->where('folio', $record_id)->first();
            


            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $data = [
                'current_user' => $current_user,
                'template_color' => 'theme-green',
                'status' => "error",
                'current' => 'Realstates',
                'results' => $realstate,
                'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
            ];
            
            
            if($_SESSION["user_type"]==0){
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("edit-realstate")
                .view("scripts");
            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }






    
    public function update()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            
            if($_SESSION["user_type"]==0){

                

                $RealstateModel = new RealstateModel();
                $data = [
                    'nombre'        => $_POST["nombre"],
                    'url_image'        => $_POST["url_image"],
                    'color' => $_POST["color"],
                    'razon_social' => $_POST["razon_social"],
                    'rfc' => $_POST["rfc"],
                    'address_street' => $_POST["address_street"],
                    'address_suburb' => $_POST["address_suburb"],
                    'address_cp' => $_POST["address_cp"],
                    'contact_name' => $_POST["contact_name"],
                    'contact_email' => $_POST["contact_email"],
                    'contact_phone' => $_POST["contact_phone"],
                    'last_update' => date('Y-m-d G:i:s'),
                    'creation_date' => date('Y-m-d G:i:s'),
                ];
                
                
                $RealstateModel->update($_POST["id"],$data);
                
                return redirect()->to(base_url()."/realstates");

            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }



  
















}
