<?php

namespace App\Controllers;
use Config\Services;
//$session = \Config\Services::session();
use App\Models\UserModel;
use App\Models\RealstateModel;
use App\Models\OptionsModel;
$session = \Config\Services::session();
$session->start();



class Users extends BaseController
{

    public function index()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
            
            $RealstateModel = new RealstateModel();
            $realstates = $RealstateModel->findAll();
            
            
            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();

            
            $optionsModel = new OptionsModel();
            $options = $optionsModel->findAll();

            
            //print_r($users);
            
            if($_SESSION["user_type"]==0){    
                $userModel = new UserModel();
                $users = $userModel->findAll();
                $data = [
                    'options' => $options,
                    'current_user' => $current_user,
                    'realstates' => $realstates,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'current' => 'Usuarios',
                    'results' => $users,
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
            
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("usuarios")
                .view("scripts");
            }else{                 
                if($_SESSION["user_type"]==1){    
                    $userModel = new UserModel();
                    $users = $userModel->where('agencia', $_SESSION["agencia"])->findAll();
                    $data = [
                        'current_user' => $current_user,
                        'realstates' => $realstates,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'current' => 'Usuarios',
                        'results' => $users,
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("usuarios")
                    .view("scripts");
                }else{
                    return redirect()->to(base_url());
                }
            }
            
        }else{
         
            return redirect()->to(base_url());
                    
        }
    }




    
    public function create()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            
            $RealstateModel = new RealstateModel();


            $userModel = new UserModel();
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
           
            
            
            if($_SESSION["user_type"]==0){
                $realstates = $RealstateModel->findAll();
                $data = [
                    'current_user' => $current_user,
                    'realstates' => $realstates,
                    'template_color' => 'theme-green',
                    'status' => "error",
                    'current' => 'Usuarios',
                    'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                ];
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("create-user")
                .view("scripts");
            }else{
                if($_SESSION["user_type"]==1){
                    $realstates = $RealstateModel->where('id', $_SESSION["agencia"])->findAll();
                    $data = [
                        'current_user' => $current_user,
                        'realstates' => $realstates,
                        'template_color' => 'theme-green',
                        'status' => "error",
                        'current' => 'Usuarios',
                        'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
                    ];
                    return view('head', $data)
                    .view("aside")
                    .view("header")
                    .view("create-user")
                    .view("scripts");
                }else{
                    return redirect()->to(base_url());
                }
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }








    
    public function insert()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            if($_SESSION["user_type"]==0 || $_SESSION["user_type"]==1){

                
                $userModel = new UserModel();
                $validate_email = $userModel->where('email', $_POST["email"])->first();
                if(!$validate_email){
                    $token_recover=$this->custom_random_string_alpha(10);
                    $post_json='{
                        "FromEmail":"contacto-dcm@develops.mx",
                        "FromName":"Creación de cuenta nueva",
                        "Subject": "DCM",
                        "Text-part":"",
                        "Html-part": "<h1>Hola '.$_POST["first_name"].'</h1><p>Se ha creado tu cuenta dentro de la plataforma, tus accesos iniciales son:</p><p><strong>URL</strong>: <a href=\"'.base_url().'\">'.base_url().'</a><br><strong>Usuario</strong>: '.$_POST["email"].'<br><strong>Contraseña</strong>: '.$token_recover.'</p><p>Te sugerimos que accedas a la siguiente liga para crearte una contraseña propia:</p><p><a href=\"'.base_url().'/reassign-password?token='.$token_recover.'\">'.base_url().'/reasign-password?token='.$token_recover.'</a></p>",
                        "Recipients": [{"Email":"'.$_POST["email"].'"}]
                    }';
                    
                    $new_password=password_hash($token_recover, PASSWORD_DEFAULT);
                    
                    $response_email=$this->send_email_mailjet($post_json);


                    $UserModel = new UserModel();
                    $data = [
                        'folio'       => time(),
                        'first_name'        => $_POST["first_name"],
                        'last_name'        => $_POST["last_name"],
                        'email' => $_POST["email"],
                        'password' => $new_password,
                        'phone' => $_POST["phone"],
                        'user_type' => $_POST["user_type"],
                        'url_image' => $_POST["url_image"],
                        'job_title' => $_POST["job_title"],
                        'agencia' => $_POST["agencia"],
                        'creation_date' => date('Y-m-d G:i:s'),
                        'last_update' => date('Y-m-d G:i:s'),
                        'token_recover' => $token_recover,
                        'last_password_update' => date('Y-m-d G:i:s'),
                    ];
                    
                    $UserModel->insert($data);
                    
                    
                    //echo $response_email;

                    return redirect()->to(base_url()."/usuarios");

                }else{
                    
                    return redirect()->to(base_url()."/usuarios?error=email_duplicated");
                }


            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }















    
    public function edit($record_id='')
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            $RealstateModel = new RealstateModel();
            $realstates = $RealstateModel->findAll();

            $userModel = new UserModel();
            $usuario = $userModel->where('folio', $record_id)->first();
            
            $current_user = $userModel->where('email', $_SESSION["email"])->first();
            $data = [
                'current_user' => $current_user,
                'realstates' => $realstates,
                'template_color' => 'theme-green',
                'status' => "error",
                'current' => 'Usuarios',
                'results' => $usuario,
                'body_x_data' => "{ page: 'comingSoon', 'loaded': true, 'darkMode': false, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }"
            ];
            
            
            if($_SESSION["user_type"]==0){
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("edit-user")
                .view("scripts");
            }else{
                return view('head', $data)
                .view("aside")
                .view("header")
                .view("edit-user")
                .view("scripts");
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }






  






    public function update()
    {
        if(isset($_SESSION["email"])){
            $now = time(); // Checking the time now when home page starts.
            if ($now > $_SESSION['expire']) {
                return redirect()->to(base_url()."/logout");
            }
        
            if($_SESSION["user_type"]==0 || $_SESSION["user_type"]==1){

                    if($_SESSION["user_type"]==1){
                        if($_POST["user_type"]==0){
                            return redirect()->to(base_url()."/usuarios?error=not_authorized");
                        }
                    }


                    $UserModel = new UserModel();
                    $data = [
                        'first_name'        => $_POST["first_name"],
                        'last_name'        => $_POST["last_name"],
                        'email' => $_POST["email"],
                        'phone' => $_POST["phone"],
                        'url_image' => $_POST["url_image"],
                        'job_title' => $_POST["job_title"],
                        'locked_account' => $_POST["locked_account"],
                        'user_type' => $_POST["user_type"],
                        'last_update' => date('Y-m-d G:i:s'),
                    ];
                    
                    $UserModel->update($_POST["id"], $data);


                    return redirect()->to(base_url()."/usuarios");

            }else{
                return redirect()->to(base_url());
            }

        }else{
         
            return redirect()->to(base_url());
                    
        }
    }























    
    function custom_random_string_alpha($length) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[ord(random_bytes(1)) % $charactersLength];
        }
        return $randomString;
    }
    
    
    function send_email_mailjet($post_json) {
        $curl = curl_init();
            
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.mailjet.com/v3/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $post_json,
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'user: 18869dfe9e6e215645054e4de644f2fc:a654193ef1af770921b6946ad030a537',
            'Authorization: Basic OWY2ZjA0ZjZhZDZmZTRhNzJmYzIxYThjMWRmNDlkN2Q6NjljNjFiMTNiMmQwM2I2N2Q1ZDk2ZTAwN2IyNDRiZTQ='
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);


        return $response;
    }



}
