if (typeof jQuery === "undefined") {
    throw new Error("jQuery plugins need to be before this file");
}

AdminBSB = {};
AdminBSB.options = {
    colors: {
        red: '#F44336',
        pink: '#E91E63',
        purple: '#9C27B0',
        deepPurple: '#673AB7',
        indigo: '#3F51B5',
        blue: '#2196F3',
        lightBlue: '#03A9F4',
        cyan: '#00BCD4',
        teal: '#009688',
        green: '#4CAF50',
        lightGreen: '#8BC34A',
        lime: '#CDDC39',
        yellow: '#ffe821',
        amber: '#FFC107',
        orange: '#FF9800',
        deepOrange: '#FF5722',
        brown: '#795548',
        grey: '#9E9E9E',
        blueGrey: '#607D8B',
        black: '#000000',
        white: '#ffffff'
    },
    leftSideBar: {
        scrollColor: 'rgba(0,0,0,0.5)',
        scrollWidth: '4px',
        scrollAlwaysVisible: false,
        scrollBorderRadius: '0',
        scrollRailBorderRadius: '0',
        scrollActiveItemWhenPageLoad: true,
        breakpointWidth: 1170
    },
    dropdownMenu: {
        effectIn: 'fadeIn',
        effectOut: 'fadeOut'
    }
}

/* Left Sidebar - Function =================================================================================================
*  You can manage the left sidebar menu options
*  
*/
AdminBSB.leftSideBar = {
    activate: function () {
        var _this = this;
        var jQuerybody = jQuery('body');
        var jQueryoverlay = jQuery('.overlay');

        //Close sidebar
        jQuery(window).click(function (e) {
            var jQuerytarget = jQuery(e.target);
            if (e.target.nodeName.toLowerCase() === 'i') { jQuerytarget = jQuery(e.target).parent(); }

            if (!jQuerytarget.hasClass('bars') && _this.isOpen() && jQuerytarget.parents('#leftsidebar').length === 0) {
                if (!jQuerytarget.hasClass('js-right-sidebar')) jQueryoverlay.fadeOut();
                jQuerybody.removeClass('overlay-open');
            }
        });

        

       $('.menu-toggle.toggled').each( function (i, val) {
            jQuery(val).next().slideToggle(0);
        });

        $('.menu .list li.active').each( function (i, val) {
            var jQueryactiveAnchors = jQuery(val).find('a:eq(0)');

            jQueryactiveAnchors.addClass('toggled');
            jQueryactiveAnchors.next().show();
        });

        

        //Collapse or Expand Menu
        jQuery('.menu-toggle').on('click', function (e) {
            var jQuerythis = jQuery(this);
            var jQuerycontent = jQuerythis.next();

            if (jQuery(jQuerythis.parents('ul')[0]).hasClass('list')) {
                var jQuerynot = jQuery(e.target).hasClass('menu-toggle') ? e.target : jQuery(e.target).parents('.menu-toggle');

                $('.menu-toggle.toggled').not(jQuerynot).next().each( function (i, val) {
                    if (jQuery(val).is(':visible')) {
                        jQuery(val).prev().toggleClass('toggled');
                        jQuery(val).slideUp();
                    }
                });
            }

            jQuerythis.toggleClass('toggled');
            jQuerycontent.slideToggle(320);
        });

        //Set menu height
        _this.setMenuHeight();
        _this.checkStatuForResize(true);
        jQuery(window).resize(function () {
            _this.setMenuHeight();
            _this.checkStatuForResize(false);
        });

        //Set Waves
        Waves.attach('.menu .list a', ['waves-block']);
        Waves.init();
    },
    setMenuHeight: function (isFirstTime) {
       /* if (typeof fn.slimScroll != 'undefined') {
            var configs = AdminBSB.options.leftSideBar;
            var height = (jQuery(window).height() - (jQuery('.legal').outerHeight() + jQuery('.user-info').outerHeight() + jQuery('.navbar').innerHeight()));
            var jQueryel = jQuery('.list');

            jQueryel.slimscroll({
                height: height + "px",
                color: configs.scrollColor,
                size: configs.scrollWidth,
                alwaysVisible: configs.scrollAlwaysVisible,
                borderRadius: configs.scrollBorderRadius,
                railBorderRadius: configs.scrollRailBorderRadius
            });

            //Scroll active menu item when page load, if option set = true
            if (AdminBSB.options.leftSideBar.scrollActiveItemWhenPageLoad) {
                var activeItemOffsetTop = jQuery('.menu .list li.active')[0].offsetTop
                if (activeItemOffsetTop > 150) jQueryel.slimscroll({ scrollTo: activeItemOffsetTop + 'px' });
            }
        }*/
    },
    checkStatuForResize: function (firstTime) {
        var jQuerybody = jQuery('body');
        var jQueryopenCloseBar = jQuery('.navbar .navbar-header .bars');
        var width = jQuerybody.width();

        if (firstTime) {
            jQuerybody.find('.content, .sidebar').addClass('no-animate').delay(1000).queue(function () {
                jQuery(this).removeClass('no-animate').dequeue();
            });
        }

        if (width < AdminBSB.options.leftSideBar.breakpointWidth) {
            jQuerybody.addClass('ls-closed');
            jQueryopenCloseBar.fadeIn();
        }
        else {
            jQuerybody.removeClass('ls-closed');
            jQueryopenCloseBar.fadeOut();
        }
    },
    isOpen: function () {
        return jQuery('body').hasClass('overlay-open');
    }
};
//==========================================================================================================================

/* Right Sidebar - Function ================================================================================================
*  You can manage the right sidebar menu options
*  
*/
AdminBSB.rightSideBar = {
    activate: function () {
        var _this = this;
        var jQuerysidebar = jQuery('#rightsidebar');
        var jQueryoverlay = jQuery('.overlay');

        //Close sidebar
        jQuery(window).click(function (e) {
            var jQuerytarget = jQuery(e.target);
            if (e.target.nodeName.toLowerCase() === 'i') { jQuerytarget = jQuery(e.target).parent(); }

            if (!jQuerytarget.hasClass('js-right-sidebar') && _this.isOpen() && jQuerytarget.parents('#rightsidebar').length === 0) {
                if (!jQuerytarget.hasClass('bars')) jQueryoverlay.fadeOut();
                jQuerysidebar.removeClass('open');
            }
        });

        jQuery('.js-right-sidebar').on('click', function () {
            jQuerysidebar.toggleClass('open');
            if (_this.isOpen()) { jQueryoverlay.fadeIn(); } else { jQueryoverlay.fadeOut(); }
        });
    },
    isOpen: function () {
        return jQuery('.right-sidebar').hasClass('open');
    }
}
//==========================================================================================================================

/* Searchbar - Function ================================================================================================
*  You can manage the search bar
*  
*/
var jQuerysearchBar = jQuery('.search-bar');
AdminBSB.search = {
    activate: function () {
        var _this = this;

        //Search button click event
        jQuery('.js-search').on('click', function () {
            _this.showSearchBar();
        });

        //Close search click event
        jQuerysearchBar.find('.close-search').on('click', function () {
            _this.hideSearchBar();
        });

        //ESC key on pressed
        jQuerysearchBar.find('input[type="text"]').on('keyup', function (e) {
            if (e.keyCode == 27) {
                _this.hideSearchBar();
            }
        });
    },
    showSearchBar: function () {
        jQuerysearchBar.addClass('open');
        jQuerysearchBar.find('input[type="text"]').focus();
    },
    hideSearchBar: function () {
        jQuerysearchBar.removeClass('open');
        jQuerysearchBar.find('input[type="text"]').val('');
    }
}
//==========================================================================================================================

/* Navbar - Function =======================================================================================================
*  You can manage the navbar
*  
*/
AdminBSB.navbar = {
    activate: function () {
        var jQuerybody = jQuery('body');
        var jQueryoverlay = jQuery('.overlay');

        //Open left sidebar panel
        jQuery('.bars').on('click', function () {
            jQuerybody.toggleClass('overlay-open');
            if (jQuerybody.hasClass('overlay-open')) { jQueryoverlay.fadeIn(); } else { jQueryoverlay.fadeOut(); }
        });

        //Close collapse bar on click event
        jQuery('.nav [data-close="true"]').on('click', function () {
            var isVisible = jQuery('.navbar-toggle').is(':visible');
            var jQuerynavbarCollapse = jQuery('.navbar-collapse');

            if (isVisible) {
                jQuerynavbarCollapse.slideUp(function () {
                    jQuerynavbarCollapse.removeClass('in').removeAttr('style');
                });
            }
        });
    }
}
//==========================================================================================================================

/* Input - Function ========================================================================================================
*  You can manage the inputs(also textareas) with name of class 'form-control'
*  
*/
AdminBSB.input = {
    activate: function () {
        //On focus event
        jQuery('.form-control').focus(function () {
            jQuery(this).parent().addClass('focused');
        });

        //On focusout event
        jQuery('.form-control').focusout(function () {
            var jQuerythis = jQuery(this);
            if (jQuerythis.parents('.form-group').hasClass('form-float')) {
                if (jQuerythis.val() == '') { jQuerythis.parents('.form-line').removeClass('focused'); }
            }
            else {
                jQuerythis.parents('.form-line').removeClass('focused');
            }
        });

        //On label click
        jQuery('body').on('click', '.form-float .form-line .form-label', function () {
            jQuery(this).parent().find('input').focus();
        });

        //Not blank form
        jQuery('.form-control').each(function () {
            if (jQuery(this).val() !== '') {
                jQuery(this).parents('.form-line').addClass('focused');
            }
        });
    }
}
//==========================================================================================================================

/* Form - Select - Function ================================================================================================
*  You can manage the 'select' of form elements
*  
*/
AdminBSB.select = {
    activate: function () {
        jQuery('select:not(.ms)').selectpicker();
    }
}
//==========================================================================================================================

/* DropdownMenu - Function =================================================================================================
*  You can manage the dropdown menu
*  
*/

AdminBSB.dropdownMenu = {
    activate: function () {
        var _this = this;

        jQuery('.dropdown, .dropup, .btn-group').on({
            "show.bs.dropdown": function () {
                var dropdown = _this.dropdownEffect(this);
                _this.dropdownEffectStart(dropdown, dropdown.effectIn);
            },
            "shown.bs.dropdown": function () {
                var dropdown = _this.dropdownEffect(this);
                if (dropdown.effectIn && dropdown.effectOut) {
                    _this.dropdownEffectEnd(dropdown, function () { });
                }
            },
            "hide.bs.dropdown": function (e) {
                var dropdown = _this.dropdownEffect(this);
                if (dropdown.effectOut) {
                    e.preventDefault();
                    _this.dropdownEffectStart(dropdown, dropdown.effectOut);
                    _this.dropdownEffectEnd(dropdown, function () {
                        dropdown.dropdown.removeClass('open');
                    });
                }
            }
        });

        //Set Waves
        Waves.attach('.dropdown-menu li a', ['waves-block']);
        Waves.init();
    },
    dropdownEffect: function (target) {
        var effectIn = AdminBSB.options.dropdownMenu.effectIn, effectOut = AdminBSB.options.dropdownMenu.effectOut;
        var dropdown = jQuery(target), dropdownMenu = jQuery('.dropdown-menu', target);

        if (dropdown.length > 0) {
            var udEffectIn = dropdown.data('effect-in');
            var udEffectOut = dropdown.data('effect-out');
            if (udEffectIn !== undefined) { effectIn = udEffectIn; }
            if (udEffectOut !== undefined) { effectOut = udEffectOut; }
        }

        return {
            target: target,
            dropdown: dropdown,
            dropdownMenu: dropdownMenu,
            effectIn: effectIn,
            effectOut: effectOut
        };
    },
    dropdownEffectStart: function (data, effectToStart) {
        if (effectToStart) {
            data.dropdown.addClass('dropdown-animating');
            data.dropdownMenu.addClass('animated dropdown-animated');
            data.dropdownMenu.addClass(effectToStart);
        }
    },
    dropdownEffectEnd: function (data, callback) {
        var animationEnd = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
        data.dropdown.one(animationEnd, function () {
            data.dropdown.removeClass('dropdown-animating');
            data.dropdownMenu.removeClass('animated dropdown-animated');
            data.dropdownMenu.removeClass(data.effectIn);
            data.dropdownMenu.removeClass(data.effectOut);

            if (typeof callback == 'function') {
                callback();
            }
        });
    }
}
//==========================================================================================================================

/* Browser - Function ======================================================================================================
*  You can manage browser
*  
*/
var edge = 'Microsoft Edge';
var ie10 = 'Internet Explorer 10';
var ie11 = 'Internet Explorer 11';
var opera = 'Opera';
var firefox = 'Mozilla Firefox';
var chrome = 'Google Chrome';
var safari = 'Safari';

AdminBSB.browser = {
    activate: function () {
        var _this = this;
        var className = _this.getClassName();

        if (className !== '') jQuery('html').addClass(_this.getClassName());
    },
    getBrowser: function () {
        var userAgent = navigator.userAgent.toLowerCase();

        if (/edge/i.test(userAgent)) {
            return edge;
        } else if (/rv:11/i.test(userAgent)) {
            return ie11;
        } else if (/msie 10/i.test(userAgent)) {
            return ie10;
        } else if (/opr/i.test(userAgent)) {
            return opera;
        } else if (/chrome/i.test(userAgent)) {
            return chrome;
        } else if (/firefox/i.test(userAgent)) {
            return firefox;
        } else if (!!navigator.userAgent.match(/Version\/[\d\.]+.*Safari/)) {
            return safari;
        }

        return undefined;
    },
    getClassName: function () {
        var browser = this.getBrowser();

        if (browser === edge) {
            return 'edge';
        } else if (browser === ie11) {
            return 'ie11';
        } else if (browser === ie10) {
            return 'ie10';
        } else if (browser === opera) {
            return 'opera';
        } else if (browser === chrome) {
            return 'chrome';
        } else if (browser === firefox) {
            return 'firefox';
        } else if (browser === safari) {
            return 'safari';
        } else {
            return '';
        }
    }
}
//==========================================================================================================================

jQuery(function () {
    AdminBSB.browser.activate();
    AdminBSB.leftSideBar.activate();
    AdminBSB.rightSideBar.activate();
    AdminBSB.navbar.activate();
    AdminBSB.dropdownMenu.activate();
    AdminBSB.input.activate();
    AdminBSB.search.activate();

    setTimeout(function () { jQuery('.page-loader-wrapper').fadeOut(); }, 50);
});