<?php

function init_etomin_gateway()
{

    require_once 'ordenData.php';

    //clase de ordenes

    require_once 'etominApi.php';

    //clase para las consultas api



    class WC_Etomin_Gateway extends WC_Payment_Gateway
    {



        public function __construct()
        {



            $this->id = 'etomin_gateway';

            $this->has_fields = false;

            $this->method_title = __('EtominApi', 'EtominP7');

            $this->method_description = __('Método de pago para WooCommerce', 'EtominP7');

            $this->title = $this->get_option('title');

            $this->description = $this->get_option('description');

            $this->init_form_fields();

            $this->init_settings();

            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));

        }

        public function init_form_fields()
        {

            $this->form_fields = array(

                'enabled' => array(

                    'title' => __('Activar/Deshabilitar', 'EtominP7'),

                    'type' => 'checkbox',

                    'label' => __('Activar Etomin', 'EtominP7'),

                    'default' => 'no',

                ),

                'title' => array(

                    'title' => __('Título', 'EtominP7'),

                    'type' => 'text',

                    'description' => __('Tarjeta de Crédito o débito', 'EtominP7'),

                    'default' => __('Tarjeta de Crédito o débito.', 'EtominP7'),

                    'desc_tip' => true,

                ),

                'description' => array(

                    'title' => __('Descripción', 'EtominP7'),

                    'type' => 'textarea',

                    'description' => __('Método de pago para WooCommerce - etomin.', 'EtominP7'),

                    'default' => __('Método de pago para WooCommerce - etomin.', 'EtominP7'),

                    'desc_tip' => true,

                ),

                'additional_field_1' => array(

                    'title' => __('Correo EtominApi', 'EtominP7'),

                    'type' => 'text',

                    'description' => __('Correo electrónico de cuenta etomin.', 'EtominP7'),

                    'default' => '',

                    'desc_tip' => true,

                ),

                'additional_field_2' => array(

                    'title' => __('Contraseña EtominApi', 'EtominP7'),

                    'type' => 'password',

                    'default' => '',

                    'description' => '<a href="https://etomin.com">¿Problemas con tu cuenta?</a>',

                    'EtominP7',

                ),

            );

        }

        public function process_admin_options()
        {

            $additional_field_1 = isset($_POST[$this->plugin_id . $this->id . '_additional_field_1']) ? wc_clean($_POST[$this->plugin_id . $this->id . '_additional_field_1']) : '';

            $additional_field_2 = isset($_POST[$this->plugin_id . $this->id . '_additional_field_2']) ? wc_clean($_POST[$this->plugin_id . $this->id . '_additional_field_2']) : '';

            if (!$this->is_valid($additional_field_1, $additional_field_2)) {

                WC_Admin_Settings::add_error(__('Claves EtominApi no válidas, Intenta nuevamente.', 'EtominP7'));

                $this->enabled = 'no';

                return;

                // No continuar con el proceso de actualizació

            }

            $current_additional_field_1 = $this->get_option('additional_field_1');

            $current_additional_field_2 = $this->get_option('additional_field_2');

            parent::process_admin_options();

        }

        // Función para validar los campos adicionales

        private function is_valid($additional_field_1, $additional_field_2)
        {

            $tokenAutenticacion = $this->authToken_etominApi_settings($additional_field_1, $additional_field_2);

            if ($tokenAutenticacion) {

                return true;

            }

            return false;

        }

        private function authToken_etominApi_settings($additional_field_1, $additional_field_2) //regresa el token de inicio de session
        {

            $api = new EtominApi('https://pagos.etomin.com/api/v1');

            //clase de las consultas api

            $authToken = $api->signin('/signin', ['email' => $additional_field_1, 'password' => $additional_field_2]);

            if (isset($authToken['authToken'])) {

                return true;

            } elseif (isset($authToken['error'])) {

                return false;

            } else {

                return false;

                //error desconocido xd

            }

        }

        //-----------------------------------------------parte de logica y vista de checkout---------------------------------------------



        //en esta funcion ya manejamos lo que traemos del formulario que pintamos xd

        public function process_payment($order_id)
        {

            $order = wc_get_order($order_id);

            // obtener la orden de woocommerce

            $order_data = new OrdenData();

            $order_data->insert_order_data($order);

            //guardar los datos del pedido en la bd

            $dataCard = array(

                'cardData' => array(

                    'cardNumber' => str_replace(' ', '', $_POST['etomin_card_number']), // Eliminar espacios en blanco del número de tarjeta

                    'cardholderName' => sanitize_text_field($_POST['etomin_card_name']), // Sanitizar el nombre del titular de la tarjeta

                    'expirationMonth' => '', // Variable para almacenar el mes de expiración

                    'expirationYear' => '', // Variable para almacenar el año de expiración

                ),

            );

            // Obtener la fecha de expiración de la tarjeta

            $expiry_date = sanitize_text_field($_POST['etomin_card_expiry_card']);

            // Dividir la fecha en mes y año

            list($month, $year) = explode('/', $expiry_date);

            // Asignar el mes y el año al array $dataCard

            $dataCard['cardData']['expirationMonth'] = $month;

            $dataCard['cardData']['expirationYear'] = $year;

            $cvc = sanitize_text_field($_POST['etomin_card_cvc']);

            //el codigo de la tarjeta

            $TokenSignin = $this->authToken_etominApi();

            //primero verifica que podemos iniciar sesion

            if ($TokenSignin) {

                $tokenCard = $this->tokenCard_etominApi($dataCard);

                //mandamos la tarjeta a tokenizar

                if ($tokenCard) {

                    $dataSale = $order_data->data_order_sale($order, $tokenCard, $cvc);

                    $Sale = $this->sale_etominApi($dataSale, $order);

                    //manda la venta a etomin y retorna respuesta

                    if ($Sale['status'] == 'APPROVED') {

                        $order->update_status('completed');

                        $order->add_order_note(__('Pago procesado correctamente con EtominApi.', 'EtominP7'));

                        return array(

                            'result' => 'success',

                            'redirect' => $this->get_return_url($order),

                        );

                    } else if ($Sale['status'] == 'PENDING') {

                        $order->update_status('pending');

                        $order->add_order_note(__('Pago pendiente. Redirigiendo a la plataforma de pago.', 'EtominP7'));

                        return array(

                            'result' => 'success',

                            'redirect' => $Sale['redirectTo'],

                        );

                    } else if ($Sale['status'] == 'DECLINED') {

                        $order->update_status('failed');

                        // Cambiar a 'failed' para establecer como fallido

                        wc_add_notice(__('El pago fue declinado. Intente con otra tarjeta.', 'EtominP7'), 'error');

                        $order->add_order_note(__('Error de pago.', 'EtominP7'));

                        return array(

                            'result' => 'failure',

                            'redirect' => $this->get_return_url($order),

                        );

                    }

                } else {

                    $order->add_order_note(__('Error de tokenización de tarjeta.', 'EtominP7'));

                    wc_add_notice(__('Error al encriptar la tarjeta.', 'EtominP7'), 'error');

                    $order->add_order_note(__('Error al encriptar la tarjeta', 'EtominP7'));

                    return false;

                }

            } else {

                $order->add_order_note(__('No se pudo iniciar sesión con etomin.', 'EtominP7'));

                wc_add_notice(__('Error de conexión con el servidor EtominApi.', 'EtominP7'), 'error');

                $order->add_order_note(__('Error de conexión con el servidor EtominApi', 'EtominP7'));

                return;

            }

        }







        private function tokenCard_etominApi($dataCard) //regresa el token de tarjeta 
        {

            $api = new EtominApi('https://pagos.etomin.com/api/v1');

            //clase de las consultas api

            $tokenAutenticacion = $this->authToken_etominApi();

            $headers = [

                'Authorization: Bearer ' . $tokenAutenticacion, // Agrega el token como un encabezado de autorización

                'Accept: application/json',

                'Content-Type: application/json',

            ];

            $cardNumberToken = $api->consult('/card/tokenizer', $dataCard, $headers);

            $key = '';

            if (isset($cardNumberToken['cardNumberToken'])) {

                // Respuesta exitosa: token de autenticación obtenido

                $key = $cardNumberToken['cardNumberToken'];

                return $key;

                // Aquí puedes realizar cualquier acción adicional que necesites para una respuesta exitosa

            } elseif (isset($cardNumberToken['error'])) {

                // Respuesta de error: credenciales incorrectas u otro error

                return false;

            } else {

                return false;

                //error desconocido xd

            }

        }

        private function sale_etominApi($dataSale, $order)
        {

            $api = new EtominApi('https://pagos.etomin.com/api/v1');

            //clase de las consultas api

            $tokenAutenticacion = $this->authToken_etominApi();

            $headers = [

                'Authorization: Bearer ' . $tokenAutenticacion, // Agrega el token como un encabezado de autorización

                'Accept: application/json',

                'Content-Type: application/json',

            ];

            $saleApi = $api->consult('/sale', $dataSale, $headers);



            if (isset($saleApi['status'])) {

                $order->update_meta_data('customerEmail', $saleApi['customerEmail']);

                $order->update_meta_data('cardNumber', $saleApi['cardNumber']);

                $order->update_meta_data('authorizationNumber', $saleApi['authorizationNumber']);

                $order->update_meta_data('transactionId', $saleApi['transactionId']);

                $order->update_meta_data('responseCode', $saleApi['responseCode']);

                $order->update_meta_data('status', $saleApi['status']);

                $order->update_meta_data('mode', $saleApi['mode']);

                $order->update_meta_data('orderId', $saleApi['orderId']);

                $order->update_meta_data('redirectUrl', $saleApi['redirectUrl']);

                $order->update_meta_data('redirectTo', $saleApi['redirectTo']);

                $order->update_meta_data('message', $saleApi['message']);

                $order->save();

                return $saleApi;

                // Aquí puedes realizar cualquier acción adicional que necesites para una respuesta exitosa

            } elseif (isset($saleApi['error']) || NULL) {

                // Respuesta de error: credenciales incorrectas u otro error

                return false;

            } else {

                return false;

                //error desconocido xd

            }

        }



        private function authToken_etominApi() //regresa el token de inicio de session
        {

            $Email_Etomin = $this->get_option('additional_field_1');

            //obtener email de etomin

            $Pass_Etomin = $this->get_option('additional_field_2');

            //obtener pass de etomin

            $api = new EtominApi('https://pagos.etomin.com/api/v1');

            //clase de las consultas api

            $authToken = $api->signin('/signin', ['email' => $Email_Etomin, 'password' => $Pass_Etomin]);

            $key = '';

            if (isset($authToken['authToken'])) {

                // Respuesta exitosa: token de autenticación obtenido

                $key = $authToken['authToken'];

                return $key;

                // Aquí puedes realizar cualquier acción adicional que necesites para una respuesta exitosa

            } elseif (isset($authToken['error'])) {

                // Respuesta de error: credenciales incorrectas u otro error

                return false;

            } else {

                return false;

                //error desconocido xd

            }

        }

        //pintamos el formulario en la vista de pagos 

        public function payment_fields()
        {

            ?>

            <link rel='stylesheet' href="<?php echo plugin_dir_url(__DIR__) . '/src/css/style.css' ?>">

            <center>

                <div id="tarjeta-formulario" class="card-container">

                    <h3><strong>Ingresar datos de tarjeta</strong></h3>

                    <div class="card-form">

                        <div class="input-container">

                            <input type="text" id="etomin_card_name" name="etomin_card_name" />

                            <label for="etomin_card_name">Nombre en la tarjeta</label>

                        </div>

                        <div class="input-container">

                            <input type="text" id="etomin_card_number" name="etomin_card_number" oninput="format_Tarjeta(event)"
                                required />

                            <label for="etomin_card_number">Número de tarjeta</label>

                            <span id="etomin_card_visa"></span>

                        </div>

                        <div class="exp-cvv-container">

                            <div class="input-container">

                                <input type="text" id="etomin_card_expiry_card" name="etomin_card_expiry_card" maxlength="5"
                                    required />

                                <label for="etomin_card_expiry_card">MM/AA</label>

                            </div>

                            <div class="input-container">

                                <input type="password" id="etomin_card_cvc" name="etomin_card_cvc" maxlength="3" required />

                                <label for="etomin_card_cvc">CVC</label>

                            </div>

                        </div>

                    </div>

                    <div class="etomin-images">

                        <img src="<?php echo plugin_dir_url(__DIR__) . '/src/img/etomin_secbadge.svg' ?>" alt="segure" width="80" />

                    </div>

                </div>

            </center>

            <script src="<?php echo plugin_dir_url(__DIR__) . '/src/js/validate_formV2.js' ?>"></script>

            <?php

        }

        //esta de validate_fields es para validar lo que traen esos inputs del formulario que pintamos en la vista :v

        public function validate_fields()
        {

            // Eliminar los espacios en blanco del número de tarjeta

            $card_number = str_replace(' ', '', $_POST['etomin_card_number']);



            // Verificar si el número de tarjeta tiene exactamente 15 o 16 dígitos después de eliminar los espacios en blanco

            if (empty($card_number) || !is_numeric($card_number) || !in_array(strlen($card_number), [15, 16])) {

                wc_add_notice(__('Por favor, introduce un número de tarjeta válido.', 'EtominP7'), 'error');

                return false;

            }



            // Verificar la validez de la tarjeta usando el algoritmo de Luhn

            if (!$this->luhnValidation($card_number)) {

                wc_add_notice(__('Datos inválidos, intenta nuevamente.', 'EtominP7'), 'error');

                return false;

            }



            // Validar la fecha de expiración de la tarjeta

            $expiry_date = $_POST['etomin_card_expiry_card'];

            if (!$this->validate_card_expiry($expiry_date)) {

                return false;

            }



            // Validar el nombre del titular de la tarjeta

            $card_name = $_POST['etomin_card_name'];

            if (empty($card_name) || strlen($card_name) < 6 || !preg_match('/^[a-zA-ZáéíóúÁÉÍÓÚñÑüÜ\'\-\s]{6,55}$/', $card_name)) {

                wc_add_notice(__('Por favor, introduce un nombre válido.', 'EtominP7'), 'error');

                return false;

            }



            // Recojer el post de CVC

            $card_cvc = str_replace(' ', '', $_POST['etomin_card_cvc']);



            // Verificar si se proporciona el código CVC

            if (empty($card_cvc) || !is_numeric($card_cvc) || strlen($card_cvc) < 3) {

                wc_add_notice(__('Por favor, introduce un código CVC válido.', 'EtominP7'), 'error');

                return false;

            } else if (strlen($card_number) == 15 && strlen($card_cvc) != 4) {

                wc_add_notice(__('En tarjetas Amex, se requieren 4 dígitos en CVC.', 'EtominP7'), 'error');

                return false;

            }



            return true;

        }

        private function validate_card_expiry($expiry)
        {

            // Eliminar cualquier carácter que no sea numérico o "/"

            $expiry = preg_replace('/[^0-9\/]/', '', $expiry);

            // Verificar si el formato es MM/AA

            if (!preg_match('/^\d{2}\/\d{2}$/', $expiry)) {

                wc_add_notice(__('Fecha de expiración de la tarjeta es incorrecta', 'EtominP7'), 'error');

                return false;

            }

            // Separar mes y año

            list($month, $year) = explode('/', $expiry);

            // Convertir a enteros

            $month = (int) $month;

            $year = (int) ('20' . $year); // Asumir que el año es del siglo 21

            // Obtener el año y mes actuales

            $currentYear = (int) date('Y');

            $currentMonth = (int) date('m');

            // Verificar si el mes está entre 01 y 12

            if ($month < 1 || $month > 12) {

                wc_add_notice(__('Mes de expiración de la tarjeta es incorrecto', 'EtominP7'), 'error');

                return false;

            }

            // Verificar si el año está en el rango válido (año actual a año actual + 6)

            $maxYear = $currentYear + 6;

            if ($year < $currentYear || $year > $maxYear) {

                wc_add_notice(__('Año de expiración de la tarjeta es incorrecto', 'EtominP7'), 'error');

                return false;

            }

            // Verificar que la fecha no sea anterior a la fecha actual

            if (($year === $currentYear && $month < $currentMonth) || $year < $currentYear) {

                wc_add_notice(__('La fecha de expiración de la tarjeta no puede ser anterior a la fecha actual', 'EtominP7'), 'error');

                return false;

            }

            // Si todas las validaciones pasan, retornar true

            return true;

        }

        private function luhnValidation($cardNumber)
        {

            // Convertir el número de tarjeta a un array de dígitos

            $digits = str_split(strrev($cardNumber));

            // Paso 1: Duplicar los dígitos en las posiciones impares

            $doubledDigits = [];

            foreach ($digits as $key => $digit) {

                if ($key % 2 != 0) {

                    $digit *= 2;

                    if ($digit > 9) {

                        $digit -= 9;

                    }

                }

                $doubledDigits[] = $digit;

            }

            // Paso 2: Sumar todos los dígitos

            $sumDigits = array_sum($doubledDigits);

            // Paso 3: Verificar si la suma es divisible por 10

            return $sumDigits % 10 === 0;

        }



        //---------------------nuevecito de paquete (no se q vrga hace xdxdxd) ------------------------

        public function handle_callback()
        {

            $order_id = isset($_GET['order_id']) ? sanitize_text_field($_GET['order_id']) : null;

            $status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : null;



            if ($order_id && $status) {

                $order = wc_get_order($order_id);

                if ($status == 'APPROVED') {

                    $order->update_status('completed');

                    $order->add_order_note(__('Pago aprobado por EtominApi.', 'EtominP7'));

                } else {

                    $order->update_status('failed');

                    $order->add_order_note(__('Pago fallido o cancelado por EtominApi.', 'EtominP7'));

                }

            }

            wp_redirect(home_url('/'));

            exit;

        }



    }

}







//lo que hace que se muestre en woomommmerce o algo asi creo



add_filter('woocommerce_payment_gateways', 'add_etomin_payment_gateway');



function add_etomin_payment_gateway($gateways)
{

    $gateways[] = 'WC_Etomin_Gateway';

    return $gateways;

}

