<?php



// Incluye el archivo wp-load.php para cargar el entorno de WordPress

require_once ('../../../../wp-load.php');



// Verifica si el entorno de WordPress se cargó correctamente

if (!defined('ABSPATH')) {

    die('Failed to load WordPress environment.');

}



$encoded_string = isset($_GET['result']) ? $_GET['result'] : '';

if (empty($encoded_string)) {

    header('Location: /');

    exit();

}



$decoded_string = base64_decode($encoded_string);



// Intentar limpiar la codificación UTF-8

$decoded_string = mb_convert_encoding($decoded_string, 'UTF-8', 'UTF-8');



// Mostrar el string decodificado para depuración

$data = json_decode($decoded_string, true);



if ($data === null) {

    header('Location: /');

    exit();

}



// Obtén el estado y la referencia

$status = $data['status'];

$reference = $data['reference'];



// Marca el pedido según el estado

$order_id = $reference; // Asumiendo que la referencia es el ID del pedido

$order = wc_get_order($order_id);



if ($order) {

    // Guarda todos los datos del JSON en los metadatos del pedido

    foreach ($data as $key => $value) {

        $order->update_meta_data($key, $value);

    }

    $order->save();



    if ($status === 'APPROVED') {

        // Cambia el estado del pedido a completado

        $order->update_status('completed');

        // Agrega una nota al pedido

        $order->add_order_note(__('Pago procesado correctamente con EtominApi.', 'EtominP7'));

        // Redirige a la página de completado de WooCommerce

        wp_redirect($order->get_checkout_order_received_url());



    } elseif ($status === 'DECLINED') {

        // Cambia el estado del pedido a cancelado

        $order->update_status('failed');

        // Agrega una nota al pedido

        $order->add_order_note(__('Pago declinado con EtominApi.', 'EtominP7'));

        // Agrega un aviso al pedido (este aviso se mostrará en la página de checkout)

        wc_add_notice(__('El pago fue declinado. Intente con otra tarjeta.', 'EtominP7'), 'error');

        // Redirige a la página de finalizar compra

        wp_redirect(wc_get_checkout_url());

        exit();

    } else {

        // Maneja otros estados o errores

        header('Location: /');

    }

    exit();

} else {

    header('Location: /');

    exit();

}



