<?php













class OrdenData






{













    function insert_order_data($order)






    {






        // Obtener los datos de la orden






        $order_data = $this->extract_order_data($order);






        // Verificar si se pudieron extraer los datos correctamente






        if (!$order_data) {






            return false;






        }






        global $wpdb;






        // Nombre de la tabla de pedidos (puedes cambiarlo según tu necesidad).






        $table_name = $wpdb->prefix . 'etomin_orders_send';






        // Insertar los datos en la tabla de pedidos utilizando una consulta preparada






        $wpdb->insert($table_name, $order_data);






        // Verificar si hubo algún error en la inserción






        if ($wpdb->last_error) {






            return false; // O puedes manejar el error de alguna otra forma






        }






        return true;






    }




















    function insert_order_response($response)






    {






        global $wpdb;






        // Nombre de la tabla de pedidos (puedes cambiarlo según tu necesidad).






        $table_name = $wpdb->prefix . 'etomin_orders_response';






        // Sanitizar los datos antes de insertarlos en la base de datos






        $data = array(






            'id' => intval($response['id']),






            'reference' => sanitize_text_field($response['reference']),






            'amount' => intval($response['amount']),






            'customerEmail' => sanitize_email($response['customerEmail']),






            'cardNumber' => sanitize_text_field($response['cardNumber']),






            'authorizationNumber' => sanitize_text_field($response['authorizationNumber']),






            'transactionId' => sanitize_text_field($response['transactionId']),






            'responseCode' => sanitize_text_field($response['responseCode']),






            'status' => sanitize_text_field($response['status']),






            'mode' => sanitize_text_field($response['mode']),






            'consolidate' => $response['consolidate'], // No es necesario sanitizar si es NULL






            'statementAccount' => $response['statementAccount'], // No es necesario sanitizar si es NULL






            'orderId' => sanitize_text_field($response['orderId'])






        );






        // Insertar los datos en la tabla de pedidos utilizando una consulta preparada






        $wpdb->insert($table_name, $data);






        // Verificar si hubo algún error en la inserción






        if ($wpdb->last_error) {






            return false; // O puedes manejar el error de alguna otra forma






        }






        return true;






    }













    // Función para extraer los datos de la orden permitiendo campos vacíos






    private function extract_order_data($order)






    {






        // Verificar si la orden es válida






        if (!is_a($order, 'WC_Order')) {






            return false;






        }






        // Obtener los detalles de la orden






        $order_id = $order->get_id();






        $total = $order->get_total();






        $first_name = $order->get_billing_first_name();






        $last_name = $order->get_billing_last_name();






        $email = $order->get_billing_email();






        $phone = $order->get_billing_phone();






        $city = $order->get_billing_city();






        $address = $order->get_billing_address_1();






        $postcode = $order->get_billing_postcode();






        $state = $order->get_billing_state();






        $date_created = $order->get_date_created()->format('Y-m-d H:i:s');






        $customer_ip = $order->get_customer_ip_address();






        // Crear y devolver el array de datos permitiendo campos vacíos






        $data = array(






            'order_id' => $order_id,






            'total' => $total,






            'first_name' => $first_name,






            'last_name' => $last_name,






            'email' => $email,






            'phone' => $phone,






            'city' => $city,






            'address' => $address,






            'postcode' => $postcode,






            'state' => $state,






            'date_created' => $date_created,






            'customer_ip' => $customer_ip






        );






        return $data;






    }




















    public function data_order_sale($order, $token, $cvc)






    {






        // Verificar si la orden es válida






        if (!is_a($order, 'WC_Order')) {






            return false;






        }






        // Obtener los detalles de la orden






        $order_id = $order->get_id();






        $total = $order->get_total();






        $first_name = $order->get_billing_first_name();






        $last_name = $order->get_billing_last_name();






        $email = $order->get_billing_email();






        $phone = $order->get_billing_phone();






        $city = $order->get_billing_city();






        $address = $order->get_billing_address_1();






        $postcode = $order->get_billing_postcode();






        $state = $order->get_billing_state();






        $customer_ip = $order->get_customer_ip_address();













        $data = array(






            "customerInformation" => array(






                "firstName" => $first_name,






                "lastName" => $last_name,






                "middleName" => '',






                "email" => $email,






                "phone1" => $phone,






                "city" => $city,






                "address1" => $address,






                "postalCode" => $postcode,






                "state" => $state,






                "country" => 'México',






                "ip" => $customer_ip,






            ),






            "cardData" => array(






                "cardNumberToken" => $token,






                "cvv" => $cvc,






            ),






            "amount" => $total,






            "currency" => 484,






            "reference" => $order_id,






        );






        return $data;






    }






}




















