// Sección de validación de fecha de vencimiento

const expiryInput = document.getElementById("etomin_card_expiry_card");



expiryInput.addEventListener("input", function () {

  expiryInput.value = validateAndFormat(expiryInput.value);

});



expiryInput.addEventListener("blur", function () {

  expiryInput.value = validateAndFormat(expiryInput.value);

  const parts = expiryInput.value.split("/");

  const currentDate = new Date();

  const currentYear = currentDate.getFullYear() % 100;

  const currentMonth = currentDate.getMonth() + 1;

  const maxYear = (currentYear + 8) % 100;



  if (

    parts.length !== 2 ||

    parts[0].length !== 2 ||

    parts[1].length !== 2 ||

    parseInt(parts[0], 10) < 1 ||

    parseInt(parts[0], 10) > 12 ||

    parseInt(parts[1], 10) < currentYear ||

    parseInt(parts[1], 10) > maxYear ||

    (parseInt(parts[1], 10) === currentYear &&

      parseInt(parts[0], 10) < currentMonth)

  ) {

    expiryInput.value = "";

  }

});



function validateAndFormat(value) {

  const currentDate = new Date();

  const currentYear = currentDate.getFullYear() % 100;

  const currentMonth = currentDate.getMonth() + 1;

  const maxYear = (currentYear + 8) % 100;



  value = value.replace(/[^0-9/]/g, "");



  const parts = value.split("/");

  if (parts[0]) {

    if (parts[0].length > 2) {

      parts[0] = parts[0].slice(0, 2);

    }

    if (parseInt(parts[0], 10) > 12) {

      parts[0] = "12";

    }

  }

  if (parts[1]) {

    if (parts[1].length > 2) {

      parts[1] = parts[1].slice(0, 2);

    }

    if (parts[1].length === 2) {

      let year = parseInt(parts[1], 10);

      if (year < currentYear) {

        parts[1] = String(currentYear).padStart(2, "0");

      } else if (year > maxYear) {

        parts[1] = String(maxYear).padStart(2, "0");

      } else if (

        year === currentYear &&

        parts[0] &&

        parseInt(parts[0], 10) < currentMonth

      ) {

        parts[0] = String(currentMonth).padStart(2, "0");

      }

    }

  }

  if (parts[0] && parts[0].length === 2 && !value.includes("/")) {

    value = parts[0] + "/" + (parts[1] || "");

  } else {

    value = parts.join("/");

  }



  if (value.length > 5) {

    value = value.slice(0, 5);

  }



  return value;

}



// Sección de validación del nombre en la tarjeta

document

  .getElementById("etomin_card_name")

  .addEventListener("input", function () {

    this.value = this.value

      .replace(/[^a-zA-ZáéíóúÁÉÍÓÚñÑ\s]/g, "")

      .replace(/\s{2,}/g, " ");

  });



// Sección de validación del CVC

document

  .getElementById("etomin_card_cvc")

  .addEventListener("input", function () {

    this.value = this.value.replace(/\D/g, "");

    if (this.value.length > 3) {

      this.value = this.value.slice(0, 3);

    }

  });



// Sección de formateo del número de tarjeta

function format_Tarjeta(event) {

  let iconCard = document.getElementById("etomin_card_visa");

  let tarjeta = event.target.value.replace(/\s/g, "").replace(/\D/g, "");

  let cvcInput = document.getElementById("etomin_card_cvc");

  let tipoTarjeta;



  if (/^4/.test(tarjeta)) {

    tipoTarjeta = "Visa";

  } else if (/^5[1-5]/.test(tarjeta)) {

    tipoTarjeta = "Mastercard";

  } else if (/^3[47]/.test(tarjeta)) {

    tipoTarjeta = "American Express";

  } else {

    tipoTarjeta = "Desconocido";

  }



  let numeroFormateado;

  if (tipoTarjeta === "Visa" || tipoTarjeta === "Mastercard") {

    numeroFormateado = tarjeta.replace(/(\d{4})(?=\d)/g, "$1 ");

  } else if (tipoTarjeta === "American Express") {

    numeroFormateado = tarjeta.replace(/(\d{4})(\d{6})(\d{5})/, "$1 $2 $3");

  } else {

    numeroFormateado = tarjeta;

  }



  event.target.value = numeroFormateado;



  let maxLengthTarjeta, maxLengthCVC;

  if (tipoTarjeta === "American Express") {

    maxLengthTarjeta = 15;

    maxLengthCVC = 4;

    iconCard.className = "input-icon-amex";

  } else if (tipoTarjeta === "Visa") {

    maxLengthTarjeta = 19;

    maxLengthCVC = 3;

    iconCard.className = "input-icon-visa";

  } else if (tipoTarjeta === "Mastercard") {

    maxLengthTarjeta = 19;

    maxLengthCVC = 3;

    iconCard.className = "input-icon-master";

  } else {

    maxLengthTarjeta = 19;

    maxLengthCVC = 3;

    iconCard.className = "input-icon-x";

  }



  event.target.maxLength = maxLengthTarjeta;

  cvcInput.maxLength = maxLengthCVC;

}

