<?php

/*

 * Plugin Name: Etomin Payment for Woocommerce

 * Plugin URI: https://www.etomin.com/

 * Author Name: PixelSiete

 * Author URI: https://pixelsiete.com

 * Description: Metodo de pago para woocommerce 

 * Version: 4.1

 * License: 1.0

 * text-domain: EtominP7

 */





//Solo se ejecute si el plugin de WooCommerce esta activo

if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))))

    return;

//al activarse el plugin crea las tablas que se requieren ya que son las que guardan las peticiones que se hacen a la API

register_activation_hook(__FILE__, 'etomin_plugin_activation');



function etomin_plugin_activation()

{

    global $wpdb;

    $table_name_send = $wpdb->prefix . 'etomin_orders_send';

    $table_name_response = $wpdb->prefix . 'etomin_orders_response';

    // Verificar si las tablas ya existen

    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name_send'") == $table_name_send && $wpdb->get_var("SHOW TABLES LIKE '$table_name_response'") == $table_name_response) {

        // Las tablas ya existen, no es necesario crearlas nuevamente

        return;

    }

    // SQL para la tabla etomin_ordens_send

    $sql_send = "CREATE TABLE IF NOT EXISTS $table_name_send (

        id int(11) NOT NULL AUTO_INCREMENT,

        order_id int(11) NOT NULL,

        total decimal(10,2) NOT NULL,

        first_name varchar(100) COLLATE utf8_unicode_ci NOT NULL,

        last_name varchar(100) COLLATE utf8_unicode_ci NOT NULL,

        email varchar(100) COLLATE utf8_unicode_ci NOT NULL,

        phone varchar(20) COLLATE utf8_unicode_ci NOT NULL,

        city varchar(100) COLLATE utf8_unicode_ci NOT NULL,

        address varchar(255) COLLATE utf8_unicode_ci NOT NULL,

        postcode varchar(20) COLLATE utf8_unicode_ci NOT NULL,

        state varchar(100) COLLATE utf8_unicode_ci NOT NULL,

        date_created datetime NOT NULL,

        customer_ip varchar(45) COLLATE utf8_unicode_ci NOT NULL,

        PRIMARY KEY (id)

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

    // SQL para la tabla etomin_ordens_response

    $sql_response = "CREATE TABLE IF NOT EXISTS $table_name_response (

        id int(11) NOT NULL AUTO_INCREMENT,

        reference varchar(50) NOT NULL,

        amount int(11) NOT NULL,

        customerEmail varchar(255) NOT NULL,

        cardNumber varchar(20) DEFAULT NULL,

        authorizationNumber varchar(20) DEFAULT NULL,

        transactionId varchar(50) DEFAULT NULL,

        responseCode varchar(10) DEFAULT NULL,

        status varchar(20) NOT NULL,

        mode varchar(20) NOT NULL,

        consolidate varchar(255) DEFAULT NULL,

        statementAccount varchar(255) DEFAULT NULL,

        orderId varchar(50) DEFAULT NULL,

        created_at timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

        PRIMARY KEY (id)

    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

    // Ejecutar consultas SQL

    $wpdb->query($sql_send);

    $wpdb->query($sql_response);

}



// Incluir el archivo que contiene la función para inicializar la pasarela de pago

require_once plugin_dir_path(__FILE__) . 'class/functions.php';



// Incluir el archivo que contiene la clase para la meta box básica

require_once plugin_dir_path(__FILE__) . 'class/metaBox.php';



// Agregar acción para inicializar la pasarela de pago

add_action('plugins_loaded', 'init_etomin_gateway');



function my_plugin_settings_link($links)

{

    // Asegurarse de que WooCommerce esté activo

    if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {

        error_log('WooCommerce está activo.'); // Mensaje de depuración

        $settings_link = '<a href="' . admin_url('admin.php?page=wc-settings&tab=checkout&section=etomin_gateway') . '">Ajustes</a>';

        array_unshift($links, $settings_link);

    } else {

        error_log('WooCommerce no está activo.'); // Mensaje de depuración

    }

    return $links;

}



add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'my_plugin_settings_link');

